/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.damage.IDamageSource;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.event.EntityLivingDeathDropsEvent;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class MCEntityLivingDeathDropsEvent
implements EntityLivingDeathDropsEvent {
    private final LivingDropsEvent event;

    public MCEntityLivingDeathDropsEvent(LivingDropsEvent event) {
        this.event = event;
    }

    @Override
    public IDamageSource getDamageSource() {
        return CraftTweakerMC.getIDamageSource(this.event.getSource());
    }

    @Override
    public void addItem(IItemStack item) {
        IEntity entity = this.getEntity();
        this.addItem(item.createEntityItem(entity.getWorld(), entity.getPosition()));
    }

    @Override
    public void addItem(IEntityItem entityItem) {
        EntityItem item = CraftTweakerMC.getEntityItem(entityItem);
        if (item != null) {
            this.event.getDrops().add(item);
        }
    }

    @Override
    public int getLootingLevel() {
        return this.event.getLootingLevel();
    }

    @Override
    public boolean getIsRecentlyHit() {
        return this.event.isRecentlyHit();
    }

    @Override
    public List<IEntityItem> getDrops() {
        return this.event.getDrops().stream().map(CraftTweakerMC::getIEntityItem).collect(Collectors.toList());
    }

    @Override
    public void setDrops(List<IEntityItem> drops) {
        this.event.getDrops().clear();
        drops.forEach(this::addItem);
    }

    @Override
    public IEntityLivingBase getEntityLivingBase() {
        return CraftTweakerMC.getIEntityLivingBase(this.event.getEntityLiving());
    }

    @Override
    public boolean isCanceled() {
        return this.event.isCanceled();
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.event.setCanceled(canceled);
    }
}

