/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.RandomPatchFeature;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ObjectHolder;
import net.yezon.theabyss.TheabyssModElements;
import net.yezon.theabyss.block.BlaruMossBlock;
import net.yezon.theabyss.block.StoneBlock;
import net.yezon.theabyss.itemgroup.TheAbyssFlowerItemGroup;

@TheabyssModElements.ModElement.Tag
public class GlowingBlaruMossBlock
extends TheabyssModElements.ModElement {
    @ObjectHolder(value="theabyss:glowing_blaru_moss")
    public static final Block block = null;
    private static Feature<BlockClusterFeatureConfig> feature = null;
    private static ConfiguredFeature<?, ?> configuredFeature = null;

    public GlowingBlaruMossBlock(TheabyssModElements instance) {
        super(instance, 529);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new FeatureRegisterHandler());
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new BlockCustomFlower());
        this.elements.items.add(() -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(TheAbyssFlowerItemGroup.tab)).setRegistryName(block.getRegistryName()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("theabyss:blue_forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("theabyss:slime_forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("theabyss:blue_mountain").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> configuredFeature);
    }

    public static class BlockCustomFlower
    extends FlowerBlock {
        public BlockCustomFlower() {
            super(Effects.field_76424_c, 100, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200947_a(SoundType.field_235579_A_).func_200948_a(0.0f, 0.0f).func_235852_d_((bs, br, bp) -> true).func_235856_e_((bs, br, bp) -> true).func_235838_a_(s -> 6));
            this.setRegistryName("glowing_blaru_moss");
        }

        public int func_220095_e() {
            return 100;
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return VoxelShapes.func_216384_a((VoxelShape)BlockCustomFlower.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        }

        public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 100;
        }

        public AbstractBlock.OffsetType func_176218_Q() {
            return AbstractBlock.OffsetType.NONE;
        }

        public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 60;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)Blocks.field_150350_a));
        }

        public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
            Block ground = state.func_177230_c();
            return ground == BlaruMossBlock.block || ground == StoneBlock.block;
        }

        public boolean func_196260_a(BlockState blockstate, IWorldReader worldIn, BlockPos pos) {
            BlockPos blockpos = pos.func_177977_b();
            BlockState groundState = worldIn.func_180495_p(blockpos);
            Block ground = groundState.func_177230_c();
            return this.func_200014_a_(groundState, (IBlockReader)worldIn, blockpos);
        }

        public PlantType getPlantType(IBlockReader world, BlockPos pos) {
            return PlantType.PLAINS;
        }
    }

    private static class FeatureRegisterHandler {
        private FeatureRegisterHandler() {
        }

        @SubscribeEvent
        public void registerFeature(RegistryEvent.Register<Feature<?>> event) {
            feature = (Feature)new RandomPatchFeature(BlockClusterFeatureConfig.field_236587_a_){

                public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, BlockClusterFeatureConfig config) {
                    RegistryKey dimensionType = world.func_201672_e().func_234923_W_();
                    boolean dimensionCriteria = false;
                    if (dimensionType == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("theabyss:the_abyss"))) {
                        dimensionCriteria = true;
                    }
                    if (!dimensionCriteria) {
                        return false;
                    }
                    return super.func_241855_a(world, generator, random, pos, config);
                }
            };
            configuredFeature = feature.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_()).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 0, 20)));
            event.getRegistry().register(feature.setRegistryName("glowing_blaru_moss"));
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("theabyss:glowing_blaru_moss"), (Object)configuredFeature);
        }
    }
}

