/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.alchemyarray;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.client.render.alchemyarray.BindingAlchemyCircleRenderer;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffect;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffectCrafting;
import wayoftime.bloodmagic.tile.TileAlchemyArray;

public class AlchemyArrayEffectBinding
extends AlchemyArrayEffectCrafting {
    public AlchemyArrayEffectBinding(ItemStack outputStack, int tickLimit) {
        super(outputStack, tickLimit);
    }

    public AlchemyArrayEffectBinding(ItemStack outputStack) {
        this(outputStack, 300);
    }

    @Override
    public boolean update(TileAlchemyArray tile, int ticksActive) {
        if (tile.func_145831_w().field_72995_K) {
            return false;
        }
        if (ticksActive >= 50 && ticksActive <= 250) {
            this.spawnLightningOnCircle(tile.func_145831_w(), tile.func_174877_v(), ticksActive);
        }
        if (ticksActive >= this.tickLimit) {
            BlockPos pos = tile.func_174877_v();
            ItemStack output = this.outputStack.func_77946_l();
            ItemEntity outputEntity = new ItemEntity(tile.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, output);
            tile.func_145831_w().func_217376_c((Entity)outputEntity);
            return true;
        }
        return false;
    }

    public void spawnLightningOnCircle(World world, BlockPos pos, int ticksActive) {
        if (ticksActive % 50 == 0) {
            int circle = ticksActive / 50 - 1;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(circle, ticksActive);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(circle, ticksActive);
            double dispX = (double)distance * Math.sin(angle);
            double dispZ = (double)(-distance) * Math.cos(angle);
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            lightningboltentity.func_70107_b((double)pos.func_177958_n() + dispX, (double)pos.func_177956_o(), (double)pos.func_177952_p() + dispZ);
            lightningboltentity.func_233623_a_(true);
            world.func_217376_c((Entity)lightningboltentity);
        }
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectBinding(this.outputStack, this.tickLimit);
    }
}

