/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionIncreasePotencyRecipeBuilder
extends BloodMagicRecipeBuilder<PotionIncreasePotencyRecipeBuilder> {
    private final List<Ingredient> input;
    private final Effect outputEffect;
    private final int amplifier;
    private final double ampDurationMod;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionIncreasePotencyRecipeBuilder(List<Ingredient> input, Effect outputEffect, int amplifier, double ampDurationMod, int syphon, int ticks, int minimumTier) {
        super(PotionIncreasePotencyRecipeBuilder.bmSerializer("flask_potionpotency"));
        this.outputEffect = outputEffect;
        this.amplifier = amplifier;
        this.ampDurationMod = ampDurationMod;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionIncreasePotencyRecipeBuilder potionIncreasePotency(Effect outputEffect, int amplifier, double ampDurationMod, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionIncreasePotencyRecipeBuilder(inputList, outputEffect, amplifier, ampDurationMod, syphon, ticks, minimumTier);
    }

    public PotionIncreasePotencyRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionIncreasePotencyRecipeResult getResult(ResourceLocation id) {
        return new PotionIncreasePotencyRecipeResult(id);
    }

    public class PotionIncreasePotencyRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionIncreasePotencyRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (PotionIncreasePotencyRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionIncreasePotencyRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.func_200304_c();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionIncreasePotencyRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionIncreasePotencyRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionIncreasePotencyRecipeBuilder.this.minimumTier);
            json.addProperty("effect", BloodMagicPotions.getRegistryName(PotionIncreasePotencyRecipeBuilder.this.outputEffect).toString());
            json.addProperty("amplifier", (Number)PotionIncreasePotencyRecipeBuilder.this.amplifier);
            json.addProperty("ampDurMod", (Number)PotionIncreasePotencyRecipeBuilder.this.ampDurationMod);
        }
    }
}

