/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockRitualStone;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.RitualHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemRitualDiviner
extends Item {
    final int type;
    public static final String tooltipBase = "tooltip.bloodmagic.diviner.";
    public static String[] names = new String[]{"normal", "dusk", "dawn"};

    public ItemRitualDiviner(int type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
        this.type = type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (context.func_195999_j().func_225608_bj_()) {
            if (context.func_195991_k().field_72995_K) {
                this.trySetDisplayedRitual(stack, context.func_195991_k(), context.func_195995_a());
            }
            return ActionResultType.SUCCESS;
        }
        if (this.addRuneToRitual(stack, context.func_195991_k(), context.func_195995_a(), context.func_195999_j())) {
            if (context.func_195991_k().field_72995_K) {
                ItemRitualDiviner.spawnParticles(context.func_195991_k(), context.func_195995_a().func_177972_a(context.func_196000_l()), 15);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean addRuneToRitual(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        Ritual ritual;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone && (ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack))) != null) {
            Direction direction = this.getDirection(stack);
            ArrayList components = Lists.newArrayList();
            ritual.gatherComponents(components::add);
            for (RitualComponent component : components) {
                if (!this.canPlaceRitualStone(component.getRuneType(), stack)) {
                    return false;
                }
                BlockPos offset = component.getOffset(direction);
                BlockPos newPos = pos.func_177971_a((Vector3i)offset);
                BlockState state = world.func_180495_p(newPos);
                Block block = state.func_177230_c();
                if (RitualHelper.isRune(world, newPos)) {
                    if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) {
                        if (!world.field_72995_K) continue;
                        this.undisplayHologram();
                        continue;
                    }
                    RitualHelper.setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                if (block.isAir(state, (IBlockReader)world, newPos)) {
                    if (!this.consumeStone(stack, world, player)) {
                        return false;
                    }
                    ((BlockRitualStone)BloodMagicBlocks.BLANK_RITUAL_STONE.get()).setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                this.notifyBlockedBuild(player, newPos);
                return false;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void trySetDisplayedRitual(ItemStack itemStack, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(itemStack));
            TileMasterRitualStone masterRitualStone = (TileMasterRitualStone)tile;
            if (ritual != null) {
                Direction direction = this.getDirection(itemStack);
                ClientHandler.setRitualHolo(masterRitualStone, ritual, direction, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void undisplayHologram() {
        ClientHandler.setRitualHoloToNull();
    }

    public boolean consumeStone(ItemStack stack, World world, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (ItemStack newStack : inventory) {
            Block block;
            Item item;
            if (newStack.func_190926_b() || !((item = newStack.func_77973_b()) instanceof BlockItem) || !((block = ((BlockItem)item).func_179223_d()) instanceof BlockRitualStone)) continue;
            newStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack));
        if (ritual != null) {
            boolean extraInfo;
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.currentRitual", new Object[]{new TranslationTextComponent(ritual.getTranslationKey())}));
            boolean sneaking = Screen.func_231173_s_();
            boolean bl = extraInfo = sneaking && Screen.func_231174_t_();
            if (extraInfo) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    if (!TextHelper.canTranslate(ritual.getTranslationKey() + "." + type.name().toLowerCase(Locale.ROOT) + ".info")) continue;
                    tooltip.add((ITextComponent)new TranslationTextComponent(ritual.getTranslationKey() + "." + type.name().toLowerCase(Locale.ROOT) + ".info"));
                }
            } else if (sneaking) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.currentDirection", new Object[]{Utils.toFancyCasing(this.getDirection(stack).name())}));
                tooltip.add((ITextComponent)new StringTextComponent(""));
                Tuple<Integer, Map<EnumRuneType, Integer>> runeCount = RitualHelper.countRunes(ritual);
                int totalRunes = (Integer)runeCount.func_76341_a();
                Map runeMap = (Map)runeCount.func_76340_b();
                for (EnumRuneType type : EnumRuneType.values()) {
                    int count = runeMap.getOrDefault((Object)type, 0);
                    if (count <= 0) continue;
                    tooltip.add((ITextComponent)new TranslationTextComponent(tooltipBase + type.translationKey, new Object[]{count}).func_240699_a_(type.colorCode));
                }
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.totalRune", new Object[]{totalRunes}));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                if (TextHelper.canTranslate(ritual.getTranslationKey() + ".info")) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(ritual.getTranslationKey() + ".info"));
                    tooltip.add((ITextComponent)new StringTextComponent(""));
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.extraInfo").func_240699_a_(TextFormatting.BLUE));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.extraExtraInfo").func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockRayTraceResult ray = ItemRitualDiviner.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                this.cycleRitual(stack, player, false);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!world.field_72995_K) {
            this.cycleDirection(stack, player);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void func_219972_a(World worldIn, LivingEntity entityLiving, ItemStack stack, int count) {
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            BlockRayTraceResult ray = ItemRitualDiviner.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return;
            }
            if (!player.field_82175_bq) {
                if (player.func_225608_bj_()) {
                    this.cycleRitual(stack, player, true);
                } else {
                    this.cycleDirection(stack, player);
                }
            }
        }
    }

    public void cycleDirection(ItemStack stack, PlayerEntity player) {
        Direction newDirection;
        Direction direction = this.getDirection(stack);
        switch (direction) {
            case NORTH: {
                newDirection = Direction.EAST;
                break;
            }
            case EAST: {
                newDirection = Direction.SOUTH;
                break;
            }
            case SOUTH: {
                newDirection = Direction.WEST;
                break;
            }
            case WEST: {
                newDirection = Direction.NORTH;
                break;
            }
            default: {
                newDirection = Direction.NORTH;
            }
        }
        this.setDirection(stack, newDirection);
        this.notifyDirectionChange(newDirection, player);
    }

    public void notifyDirectionChange(Direction direction, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.diviner.currentDirection", new Object[]{Utils.toFancyCasing(direction.name())}), true);
    }

    public void setDirection(ItemStack stack, Direction direction) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("direction", direction.func_176745_a());
    }

    public Direction getDirection(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
            return Direction.NORTH;
        }
        CompoundNBT tag = stack.func_77978_p();
        int dir = tag.func_74762_e("direction");
        if (dir == 0) {
            return Direction.NORTH;
        }
        return Direction.values()[tag.func_74762_e("direction")];
    }

    public void cycleRitual(ItemStack stack, PlayerEntity player, boolean reverse) {
        String key = this.getCurrentRitual(stack);
        ArrayList rituals = BloodMagic.RITUAL_MANAGER.getSortedRituals();
        if (reverse) {
            rituals = Lists.newArrayList(rituals);
            Collections.reverse(rituals);
        }
        String firstId = "";
        boolean foundId = false;
        boolean foundFirst = false;
        for (Ritual ritual : rituals) {
            String id = BloodMagic.RITUAL_MANAGER.getId(ritual);
            if (!BloodMagic.RITUAL_MANAGER.enabled(id, false) || !this.canDivinerPerformRitual(stack, ritual)) continue;
            if (!foundFirst) {
                firstId = id;
                foundFirst = true;
            }
            if (foundId) {
                this.setCurrentRitual(stack, id);
                this.notifyRitualChange(id, player);
                return;
            }
            if (!id.equals(key)) continue;
            foundId = true;
        }
        if (foundFirst) {
            this.setCurrentRitual(stack, firstId);
            this.notifyRitualChange(firstId, player);
        }
    }

    public boolean canDivinerPerformRitual(ItemStack stack, Ritual ritual) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            if (this.canPlaceRitualStone(component.getRuneType(), stack)) continue;
            return false;
        }
        return true;
    }

    public void notifyRitualChange(String key, PlayerEntity player) {
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
        if (ritual != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(ritual.getTranslationKey()), true);
        }
    }

    public void setCurrentRitual(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74778_a("current_ritual", key);
    }

    public String getCurrentRitual(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74779_i("current_ritual");
    }

    public boolean canPlaceRitualStone(EnumRuneType rune, ItemStack stack) {
        int meta = this.type;
        switch (rune) {
            case BLANK: 
            case AIR: 
            case EARTH: 
            case FIRE: 
            case WATER: {
                return true;
            }
            case DUSK: {
                return meta >= 1;
            }
            case DAWN: {
                return meta >= 2;
            }
        }
        return false;
    }

    public static void spawnParticles(World worldIn, BlockPos pos, int amount) {
        BlockState state = worldIn.func_180495_p(pos);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block.isAir(state, (IBlockReader)worldIn, pos)) {
            for (int i = 0; i < amount; ++i) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat(), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2);
            }
        }
    }

    public void notifyBlockedBuild(PlayerEntity player, BlockPos pos) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.diviner.blockedBuild", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), true);
    }
}

