/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.ItemLivingTome;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;
import wayoftime.bloodmagic.common.item.inventory.InventoryTrainingBracelet;

public class ContainerTrainingBracelet
extends Container {
    public final InventoryTrainingBracelet inventoryTrainer;
    private final int PLAYER_INVENTORY_ROWS = 3;
    private final int PLAYER_INVENTORY_COLUMNS = 9;
    public final PlayerEntity player;
    public final ItemStack trainerStack;
    public int lastGhostSlotClicked = -1;
    private int slotsOccupied = 16;

    public ContainerTrainingBracelet(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        this(windowId, playerInventory.field_70458_d, playerInventory, extraData.func_150791_c());
    }

    public ContainerTrainingBracelet(int windowId, PlayerEntity player, PlayerInventory playerInventory, ItemStack filterStack) {
        super((ContainerType)BloodMagicBlocks.TRAINING_BRACELET_CONTAINER.get(), windowId);
        this.player = player;
        this.trainerStack = filterStack;
        this.inventoryTrainer = ((ItemLivingTrainer)filterStack.func_77973_b()).toInventory(filterStack);
        int currentSlotHeldIn = player.field_71071_by.field_70461_c;
        this.setup(playerInventory, currentSlotHeldIn);
    }

    public void setup(PlayerInventory inventory, int currentSlotHeldIn) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.func_75146_a(new SlotTomeItem(this, this.inventoryTrainer, this.player, j + i * 4, 110 + j * 21 - 21, 15 + i * 21));
            }
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 105 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.func_75146_a(new SlotDisabled((IInventory)this.player.field_71071_by, actionBarIndex, 8 + actionBarIndex * 18, 163));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, actionBarIndex, 8 + actionBarIndex * 18, 163));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        PlayerInventory inventoryPlayer = player.field_71071_by;
        if (slotId >= 0 && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof SlotTomeItem) {
            this.lastGhostSlotClicked = slot.getSlotIndex();
            if (dragType == 0 || dragType == 1) {
                ItemStack slotStack = slot.func_75211_c();
                ItemStack heldStack = inventoryPlayer.func_70445_o();
                if (dragType == 0) {
                    if (heldStack.func_190926_b() && !slotStack.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }
                    if (!heldStack.func_190926_b() && slotStack.func_190926_b() && heldStack.func_77973_b() instanceof ItemLivingTome) {
                        if (!((SlotTomeItem)slot).canBeAccessed()) {
                            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
                        }
                        ItemStack copyStack = heldStack.func_77946_l();
                        copyStack.func_190920_e(1);
                        slot.func_75215_d(copyStack);
                    }
                } else {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_75145_c(PlayerEntity entityPlayer) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity entityPlayer, int slotIndex) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotIndex < 0 && !this.func_75135_a(itemstack1, this.slotsOccupied, 36 + this.slotsOccupied, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(entityPlayer, itemstack1);
        }
        return itemstack;
    }

    public void saveInventory(PlayerEntity player, int slot) {
        ItemStack masterStack = this.inventoryTrainer.findParentStack(player);
        InventoryTrainingBracelet storedInv = new InventoryTrainingBracelet(masterStack);
        storedInv.func_70299_a(slot, this.func_75139_a(slot).func_75211_c());
        storedInv.save();
    }

    private class SlotTomeItem
    extends Slot {
        private final PlayerEntity player;
        private ContainerTrainingBracelet containerHolding;

        public SlotTomeItem(ContainerTrainingBracelet containerHolding, IInventory inventory, PlayerEntity player, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.player = player;
            this.containerHolding = containerHolding;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (EffectiveSide.get().isServer()) {
                this.containerHolding.saveInventory(this.player, this.field_75222_d);
            }
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity playerIn) {
            return false;
        }

        public boolean canBeAccessed() {
            return this.containerHolding.inventoryTrainer.canInventoryBeManipulated();
        }
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(IInventory inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }
    }
}

