/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.potion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.recipe.EffectHolder;

public class ItemAlchemyFlask
extends Item {
    public ItemAlchemyFlask() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB).func_200918_c(8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.arctool.uses", new Object[]{this.getRemainingUses(stack)}).func_240699_a_(TextFormatting.GOLD));
        PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
    }

    public int getRemainingUses(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack speedStack = new ItemStack((IItemProvider)this);
        items.add((Object)speedStack);
    }

    public void resyncEffectInstances(ItemStack stack) {
        List<EffectHolder> holderList = this.getEffectHoldersOfFlask(stack);
        ArrayList<EffectInstance> effectList = new ArrayList<EffectInstance>();
        for (EffectHolder holder : holderList) {
            effectList.add(holder.getEffectInstance(false, true));
        }
        this.setEffectsOfFlask(stack, effectList);
    }

    public ItemStack setEffectsOfFlask(ItemStack stack, Collection<EffectInstance> effects) {
        if (effects.isEmpty()) {
            return stack;
        }
        CompoundNBT compoundnbt = stack.func_196082_o();
        ListNBT listnbt = new ListNBT();
        for (EffectInstance effectinstance : effects) {
            listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
        }
        compoundnbt.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        return stack;
    }

    public void setEffectHoldersOfFlask(ItemStack stack, List<EffectHolder> effects) {
        if (effects.isEmpty()) {
            return;
        }
        CompoundNBT compoundnbt = stack.func_196082_o();
        ListNBT listnbt = new ListNBT();
        for (EffectHolder effectHolder : effects) {
            listnbt.add((Object)effectHolder.write(new CompoundNBT()));
        }
        compoundnbt.func_218657_a("effectholder", (INBT)listnbt);
    }

    public List<EffectHolder> getEffectHoldersOfFlask(ItemStack stack) {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        CompoundNBT tag = stack.func_77978_p();
        ListNBT tags = tag.func_150295_c("effectholder", 10);
        if (tags.isEmpty()) {
            return holderList;
        }
        for (int i = 0; i < tags.size(); ++i) {
            CompoundNBT newTag = tags.func_150305_b(i);
            EffectHolder holder = EffectHolder.read(newTag);
            if (holder == null) continue;
            holderList.add(holder);
        }
        return holderList;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldStack = playerIn.func_184586_b(handIn);
        if (this.getRemainingUses(heldStack) <= 0) {
            return ActionResult.func_226250_c_((Object)heldStack);
        }
        return DrinkHelper.func_234707_a_((World)worldIn, (PlayerEntity)playerIn, (Hand)handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity playerentity;
        PlayerEntity playerEntity = playerentity = entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null;
        if (playerentity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)playerentity, stack);
        }
        if (!worldIn.field_72995_K) {
            for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)stack)) {
                if (effectinstance.func_188419_a().func_76403_b()) {
                    effectinstance.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, entityLiving, effectinstance.func_76458_c(), 1.0);
                    continue;
                }
                entityLiving.func_195064_c(new EffectInstance(effectinstance));
            }
        }
        if (playerentity != null) {
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (!playerentity.field_71075_bZ.field_75098_d) {
                stack.func_196085_b(stack.func_77952_i() + 1);
            }
        }
        return stack;
    }
}

