/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.item.inventory.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.inventory.ItemInventory;
import wayoftime.bloodmagic.common.item.routing.CompositeFilterKey;
import wayoftime.bloodmagic.common.item.routing.ICompositeItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemCompositeFilter
extends ItemRouterFilter
implements INamedContainerProvider,
ICompositeItemFilterProvider {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack filterStack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int whitelistState;
        boolean isWhitelist;
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.compositefilter.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        if (filterStack.func_77978_p() == null) {
            return;
        }
        List<ItemStack> nestedFilters = this.getNestedFilters(filterStack);
        if (nestedFilters.size() > 0) {
            boolean sneaking = Screen.func_231173_s_();
            if (!sneaking) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.extraInfo").func_240699_a_(TextFormatting.BLUE));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.contained_filters").func_240699_a_(TextFormatting.BLUE));
                for (ItemStack nestedStack : nestedFilters) {
                    tooltip.add(nestedStack.func_200301_q());
                }
            }
        }
        boolean bl = isWhitelist = (whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0)) == 0;
        if (isWhitelist) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.whitelist").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.blacklist").func_240699_a_(TextFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, stack.func_200301_q()}));
                    continue;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.all", new Object[]{stack.func_200301_q()}));
                continue;
            }
            tooltip.add(stack.func_200301_q());
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        List<ItemStack> nestedFilters = this.getNestedFilters(stack);
        if (nestedFilters.size() > 0) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return null;
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey mainKey = this.getFilterKey(filterStack, i, ghostStack, amount);
            if (nestedList.size() > 0) {
                CompositeFilterKey compositeKey = new CompositeFilterKey(amount);
                if (mainKey != null) {
                    compositeKey.addFilterKey(mainKey);
                }
                for (ItemStack nestedStack : nestedList) {
                    compositeKey.addFilterKey(((INestableItemFilterProvider)nestedStack.func_77973_b()).getFilterKey(filterStack, i, ghostStack, amount));
                }
                filteredList.add(compositeKey);
                continue;
            }
            if (mainKey == null) continue;
            filteredList.add(mainKey);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            if (amount == 0) {
                amount = Integer.MAX_VALUE;
            }
            IFilterKey mainKey = this.getFilterKey(filterStack, i, ghostStack, amount);
            if (nestedList.size() > 0) {
                CompositeFilterKey compositeKey = new CompositeFilterKey(amount);
                if (mainKey != null) {
                    compositeKey.addFilterKey(mainKey);
                }
                for (ItemStack nestedStack : nestedList) {
                    compositeKey.addFilterKey(((INestableItemFilterProvider)nestedStack.func_77973_b()).getFilterKey(filterStack, i, ghostStack, amount));
                }
                filteredList.add(compositeKey);
                continue;
            }
            if (mainKey == null) continue;
            filteredList.add(mainKey);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            filterStack.func_77982_d(new CompoundNBT());
            tag = filterStack.func_77978_p();
        }
        if (buttonKey.equals("blackwhitelist")) {
            int nextState = 0;
            switch (currentButtonState) {
                case 0: {
                    nextState = 1;
                    break;
                }
                default: {
                    nextState = 0;
                }
            }
            tag.func_74768_a("button:blackwhitelist", nextState);
            return nextState;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            int nextState = ((INestableItemFilterProvider)nestedStack.func_77973_b()).receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
            if (nextState == -1) continue;
            return nextState;
        }
        return -1;
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag != null && buttonKey.equals("blackwhitelist")) {
            int state = tag.func_74762_e("button:blackwhitelist");
            return state;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            int currentState = ((INestableItemFilterProvider)nestedStack.func_77973_b()).getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
            if (currentState == -1) continue;
            return currentState;
        }
        return -1;
    }

    @Override
    public List<ITextComponent> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        ArrayList<ITextComponent> componentList = new ArrayList<ITextComponent>();
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentState) {
                case 1: {
                    componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.blacklist"));
                    break;
                }
                default: {
                    componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.whitelist"));
                }
            }
            return componentList;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            componentList.addAll(((INestableItemFilterProvider)nestedStack.func_77973_b()).getTextForHoverItem(filterStack, buttonKey, ghostItemSlot));
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.IPressable>> getButtonAction(ContainerFilter container) {
        ArrayList<Pair<String, Button.IPressable>> buttonList = new ArrayList<Pair<String, Button.IPressable>>();
        buttonList.add(Pair.of((Object)"blackwhitelist", (Object)new FilterButtonTogglePress("blackwhitelist", container)));
        List<ItemStack> nestedList = this.getNestedFilters(container.filterStack);
        for (ItemStack nestedStack : nestedList) {
            List<Pair<String, Button.IPressable>> nestedButtonList = ((INestableItemFilterProvider)nestedStack.func_77973_b()).getButtonAction(container);
            buttonList.addAll(nestedButtonList);
        }
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentButtonState) {
                case 1: {
                    return Pair.of((Object)176, (Object)20);
                }
            }
            return Pair.of((Object)176, (Object)0);
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            Pair<Integer, Integer> pair = ((INestableItemFilterProvider)nestedStack.func_77973_b()).getTexturePositionForState(filterStack, buttonKey, currentButtonState);
            if ((Integer)pair.getLeft() <= 0 && (Integer)pair.getRight() <= 0) continue;
            return pair;
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return buttonKey.equals("blackwhitelist");
    }

    public List<ItemStack> getNestedFilters(ItemStack mainFilterStack) {
        ArrayList<ItemStack> nestedFilters = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(mainFilterStack, 9, "filterInventory");
        for (int i = 0; i < 9; ++i) {
            ItemStack testStack = inv.func_70301_a(i);
            if (testStack.func_190926_b() || !(testStack.func_77973_b() instanceof INestableItemFilterProvider)) continue;
            nestedFilters.add(testStack);
        }
        return nestedFilters;
    }

    @Override
    public boolean canReceiveNestedFilter(ItemStack mainFilterStack, ItemStack nestedFilterStack) {
        if (nestedFilterStack.func_190926_b()) {
            return false;
        }
        if (!(nestedFilterStack.func_77973_b() instanceof INestableItemFilterProvider)) {
            return false;
        }
        boolean hasEmpty = false;
        ItemInventory inv = new ItemInventory(mainFilterStack, 9, "filterInventory");
        for (int i = 0; i < 9; ++i) {
            ItemStack testStack = inv.func_70301_a(i);
            if (testStack.func_190926_b()) {
                hasEmpty = true;
                continue;
            }
            if (!testStack.func_77973_b().equals(nestedFilterStack.func_77973_b())) continue;
            return false;
        }
        return hasEmpty;
    }

    @Override
    public ItemStack nestFilter(ItemStack mainFilterStack, ItemStack nestedFilterStack) {
        if (this.canReceiveNestedFilter(mainFilterStack, nestedFilterStack)) {
            ItemStack copyStack = mainFilterStack.func_77946_l();
            ItemInventory inv = new ItemInventory(copyStack, 9, "filterInventory");
            for (int i = 0; i < 9; ++i) {
                ItemStack testStack = inv.func_70301_a(i);
                if (!testStack.func_190926_b()) continue;
                inv.func_70299_a(i, nestedFilterStack);
                inv.func_70296_d();
                return copyStack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

