/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class TartaricForgeRecipeSerializer<RECIPE extends RecipeTartaricForge>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public TartaricForgeRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        for (int i = 0; i < 4; ++i) {
            if (!json.has("input" + i)) continue;
            JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)("input" + i)) ? JSONUtils.func_151214_t((JsonObject)json, (String)("input" + i)) : JSONUtils.func_152754_s((JsonObject)json, (String)("input" + i));
            inputList.add(Ingredient.func_199802_a((JsonElement)input));
        }
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        float minimumSouls = JSONUtils.func_151217_k((JsonObject)json, (String)"minimumDrain");
        float soulDrain = JSONUtils.func_151217_k((JsonObject)json, (String)"drain");
        return this.factory.create(recipeId, inputList, output, minimumSouls, soulDrain);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack output = buffer.func_150791_c();
        double minimumSouls = buffer.readDouble();
        double soulDrain = buffer.readDouble();
        return this.factory.create(recipeId, input, output, minimumSouls, soulDrain);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipeTartaricForge)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeTartaricForge> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, ItemStack var3, double var4, double var6);
    }
}

