/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;

public class FilterButtonPacket {
    private int slot;
    private int ghostSlot;
    private String buttonKey;
    private int currentButtonState;

    public FilterButtonPacket() {
    }

    public FilterButtonPacket(int slot, int ghostSlot, String buttonKey, int currentButtonState) {
        this.slot = slot;
        this.ghostSlot = ghostSlot;
        this.buttonKey = buttonKey;
        this.currentButtonState = currentButtonState;
    }

    public static void encode(FilterButtonPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.ghostSlot);
        buf.func_180714_a(pkt.buttonKey);
        buf.writeInt(pkt.currentButtonState);
    }

    public static FilterButtonPacket decode(PacketBuffer buf) {
        FilterButtonPacket pkt = new FilterButtonPacket(buf.readInt(), buf.readInt(), buf.func_150789_c(Short.MAX_VALUE), buf.readInt());
        return pkt;
    }

    public static void handle(FilterButtonPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FilterButtonPacket.sendKeyToServer(message, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(FilterButtonPacket msg, PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.field_71071_by.func_70301_a(msg.slot);
        }
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IItemFilterProvider) {
            ((IItemFilterProvider)itemStack.func_77973_b()).receiveButtonPress(itemStack, msg.buttonKey, msg.ghostSlot, msg.currentButtonState);
        }
    }
}

