/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;
import wayoftime.bloodmagic.recipe.EffectHolder;

public abstract class RecipePotionFlaskBase
extends BloodMagicRecipe {
    @Nonnull
    protected final List<Ingredient> input;
    @Nonnegative
    private final int syphon;
    @Nonnegative
    private final int ticks;
    @Nonnegative
    private final int minimumTier;
    public static final int MAX_INPUTS = 5;

    public RecipePotionFlaskBase(ResourceLocation id, List<Ingredient> input, int syphon, int ticks, int minimumTier) {
        super(id);
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public abstract boolean canModifyFlask(List<EffectHolder> var1);

    public abstract int getPriority(List<EffectHolder> var1);

    @Nonnull
    public List<Ingredient> getInput() {
        return this.input;
    }

    @Nonnull
    public abstract ItemStack getOutput(ItemStack var1, List<EffectHolder> var2);

    @Nonnull
    public ItemStack getExamplePotionFlask() {
        ItemStack flaskStack = new ItemStack((IItemProvider)BloodMagicItems.ALCHEMY_FLASK.get());
        ((ItemAlchemyFlask)flaskStack.func_77973_b()).setEffectHoldersOfFlask(flaskStack, this.getExampleEffectList());
        ((ItemAlchemyFlask)flaskStack.func_77973_b()).resyncEffectInstances(flaskStack);
        return flaskStack;
    }

    public abstract List<EffectHolder> getExampleEffectList();

    public final int getSyphon() {
        return this.syphon;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final int getMinimumTier() {
        return this.minimumTier;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.input.size());
        for (int i = 0; i < this.input.size(); ++i) {
            this.input.get(i).func_199564_a(buffer);
        }
        buffer.writeInt(this.syphon);
        buffer.writeInt(this.ticks);
        buffer.writeInt(this.minimumTier);
    }

    public IRecipeType<RecipePotionFlaskBase> func_222127_g() {
        return BloodMagicRecipeType.POTIONFLASK;
    }
}

