/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.harvest;

import java.util.Collection;
import java.util.List;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;

public class HarvestHandlerStem
implements IHarvestHandler {
    private static final ItemStack mockHoe = new ItemStack((IItemProvider)Items.field_151012_L, 1);

    public HarvestHandlerStem() {
        for (int i = 0; i < 4; ++i) {
            Direction facing = Direction.func_176731_b((int)i);
            HarvestRegistry.registerStemCrop(Blocks.field_150423_aK.func_176223_P(), (BlockState)Blocks.field_196711_ds.func_176223_P().func_206870_a((Property)AttachedStemBlock.field_196280_a, (Comparable)facing));
            HarvestRegistry.registerStemCrop(Blocks.field_150440_ba.func_176223_P(), (BlockState)Blocks.field_196713_dt.func_176223_P().func_206870_a((Property)AttachedStemBlock.field_196280_a, (Comparable)facing));
        }
    }

    @Override
    public boolean harvest(World world, BlockPos pos, BlockState state, List<ItemStack> drops) {
        Direction cropDir = (Direction)state.func_177229_b((Property)AttachedStemBlock.field_196280_a);
        if (cropDir != Direction.UP) {
            BlockPos cropPos = pos.func_177972_a(cropDir);
            BlockState probableCrop = world.func_180495_p(cropPos);
            Collection registeredCrops = HarvestRegistry.getStemCrops().get((Object)state);
            for (BlockState registeredCrop : registeredCrops) {
                if (registeredCrop != probableCrop) continue;
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world);
                Vector3d blockCenter = new Vector3d((double)cropPos.func_177958_n() + 0.5, (double)cropPos.func_177956_o() + 0.5, (double)cropPos.func_177952_p() + 0.5);
                List blockDrops = registeredCrop.func_215693_a(lootBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)blockCenter).func_216015_a(LootParameters.field_216289_i, (Object)mockHoe));
                drops.addAll(blockDrops);
                world.func_175655_b(cropPos, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean test(World world, BlockPos pos, BlockState state) {
        return HarvestRegistry.getStemCrops().containsKey((Object)state);
    }
}

