/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.Utils;

public class TileMimic
extends TileInventory {
    @ObjectHolder(value="bloodmagic:mimic")
    public static TileEntityType<TileMimic> TYPE;
    public static final ModelProperty<BlockState> MIMIC;
    private BlockState mimic;
    public boolean dropItemsOnBreak = true;
    public CompoundNBT tileTag = new CompoundNBT();
    public TileEntity mimicedTile = null;
    public int playerCheckRadius = 5;
    public int potionSpawnRadius = 5;
    public int potionSpawnInterval = 40;
    private int internalCounter = 0;

    public TileMimic(TileEntityType<?> type) {
        super(type, 2, "mimic");
    }

    public TileMimic() {
        this(TYPE);
    }

    public boolean onBlockActivated(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, ItemStack heldItem, Direction side) {
        List list;
        if (!heldItem.func_190926_b() && player.func_184812_l_() && !(list = PotionUtils.func_185189_a((ItemStack)heldItem)).isEmpty()) {
            if (!world.field_72995_K) {
                this.func_70299_a(1, heldItem.func_77946_l());
                world.func_184138_a(pos, state, state, 3);
                ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.potionSet")});
            }
            return true;
        }
        if (this.performSpecialAbility(player, side)) {
            return true;
        }
        if (player.func_225608_bj_()) {
            return false;
        }
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == new ItemStack((IItemProvider)BloodMagicBlocks.MIMIC.get()).func_77973_b()) {
            return false;
        }
        if (!this.func_70301_a(0).func_190926_b() && !player.func_184586_b(hand).func_190926_b()) {
            return false;
        }
        if (!this.dropItemsOnBreak && !player.func_184812_l_()) {
            return false;
        }
        Utils.insertItemToTile(this, player, 0);
        ItemStack stack = this.func_70301_a(0);
        if (!(this.mimic != null && this.mimic != Blocks.field_150350_a.func_176223_P() || stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem) || world.field_72995_K)) {
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            this.setMimic(block.func_176223_P());
        }
        this.refreshTileEntity();
        if (player.func_184812_l_()) {
            this.dropItemsOnBreak = this.func_70301_a(0).func_190926_b();
        }
        return true;
    }

    public boolean performSpecialAbility(PlayerEntity player, Direction sideHit) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (player.func_184607_cu().func_190926_b() && !this.func_70301_a(1).func_190926_b()) {
            switch (sideHit) {
                case EAST: 
                case WEST: {
                    if (player.func_225608_bj_()) {
                        this.potionSpawnRadius = Math.max(this.potionSpawnRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.potionSpawnRadius.down", new Object[]{this.potionSpawnRadius})});
                        break;
                    }
                    ++this.potionSpawnRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.potionSpawnRadius.up", new Object[]{this.potionSpawnRadius})});
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (player.func_225608_bj_()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.detectRadius.down", new Object[]{this.playerCheckRadius})});
                        break;
                    }
                    ++this.playerCheckRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.detectRadius.up", new Object[]{this.playerCheckRadius})});
                    break;
                }
                case UP: 
                case DOWN: {
                    if (player.func_225608_bj_()) {
                        this.potionSpawnInterval = Math.max(this.potionSpawnInterval - 1, 1);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.potionInterval.down", new Object[]{this.potionSpawnInterval})});
                        break;
                    }
                    ++this.potionSpawnInterval;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("chat.bloodmagic.mimic.potionInterval.up", new Object[]{this.potionSpawnInterval})});
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void refreshTileEntity() {
        if (this.mimicedTile != null) {
            this.dropMimicedTileInventory();
        }
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.func_145831_w(), this.field_174879_c, this.func_70301_a(0), this.tileTag, this.mimic);
    }

    public void dropMimicedTileInventory() {
        if (!this.func_145831_w().field_72995_K && this.mimicedTile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)((IInventory)this.mimicedTile));
        }
    }

    @Nullable
    public static TileEntity getTileFromStackWithTag(World world, BlockPos pos, ItemStack stack, @Nullable CompoundNBT tag, BlockState replacementState) {
        BlockState state;
        Block block;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && (block = ((BlockItem)stack.func_77973_b()).func_179223_d()).hasTileEntity(state = replacementState)) {
            TileEntity tile = block.createTileEntity(state, (IBlockReader)world);
            if (tile == null) {
                return null;
            }
            if (tag != null) {
                CompoundNBT copyTag = tag.func_74737_b();
                copyTag.func_74768_a("x", pos.func_177958_n());
                copyTag.func_74768_a("y", pos.func_177956_o());
                copyTag.func_74768_a("z", pos.func_177952_p());
                tile.deserializeNBT(copyTag);
            }
            tile.func_226984_a_(world, pos);
            return tile;
        }
        return null;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.writeMimic(tag);
        return tag;
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic = this.mimic;
        CompoundNBT tag = pkt.func_148857_g();
        this.deserialize(tag);
        if (!Objects.equals(oldMimic, this.mimic)) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).build();
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.dropItemsOnBreak = tag.func_74767_n("dropItemsOnBreak");
        this.tileTag = tag.func_74775_l("tileTag");
        this.readMimic(tag);
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.func_145831_w(), this.field_174879_c, this.func_70301_a(0), this.tileTag, this.mimic);
        this.playerCheckRadius = tag.func_74762_e("playerCheckRadius");
        this.potionSpawnRadius = tag.func_74762_e("potionSpawnRadius");
        this.potionSpawnInterval = Math.max(1, tag.func_74762_e("potionSpawnInterval"));
    }

    private void readMimic(CompoundNBT tag) {
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        tag.func_74757_a("dropItemsOnBreak", this.dropItemsOnBreak);
        tag.func_218657_a("tileTag", (INBT)this.tileTag);
        tag.func_74768_a("playerCheckRadius", this.playerCheckRadius);
        tag.func_74768_a("potionSpawnRadius", this.potionSpawnRadius);
        tag.func_74768_a("potionSpawnInterval", this.potionSpawnInterval);
        this.writeMimic(tag);
        return super.serialize(tag);
    }

    private void writeMimic(CompoundNBT tag) {
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
    }

    @Override
    public void dropItems() {
        if (this.dropItemsOnBreak) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
        }
        this.dropMimicedTileInventory();
    }

    static {
        MIMIC = new ModelProperty();
    }
}

