/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateAdapter
extends TypeAdapter<BlockState> {
    public BlockState read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return BlockStateAdapter.resolveBlockState(reader.nextString());
    }

    public void write(JsonWriter writer, BlockState blockState) throws IOException {
        if (blockState == null) {
            writer.nullValue();
            return;
        }
        String blockString = String.valueOf(blockState);
        if (blockString.startsWith("Block")) {
            blockString = blockString.replace("Block", "");
        }
        blockString = blockString.replace("{", "");
        blockString = blockString.replace("}", "");
        writer.value(blockString);
    }

    public static BlockState resolveBlockState(String fullString) {
        BlockState blockState;
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = fullString;
        int startIndex = fullString.indexOf(91);
        int stopIndex = fullString.indexOf(93);
        if (startIndex != -1) {
            blockString = fullString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                YungsApi.LOGGER.error("JSON: Malformed property {}. Missing a bracket?", (Object)fullString);
                YungsApi.LOGGER.error("Using air instead...");
                return Blocks.field_150350_a.func_176223_P();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = fullString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(fullString.charAt(index));
            }
        }
        try {
            blockState = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockString))).func_176223_P();
        }
        catch (Exception e) {
            YungsApi.LOGGER.error("JSON: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            YungsApi.LOGGER.error("Using air instead...");
            return Blocks.field_150350_a.func_176223_P();
        }
        if (properties.size() > 0) {
            blockState = BlockStateAdapter.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState getConfiguredBlockState(BlockState blockState, Map<String, String> properties) {
        Block block = blockState.func_177230_c();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean found = false;
            for (Property p : blockState.func_235904_r_()) {
                Property property = p;
                if (!property.func_177701_a().equals(key)) continue;
                Comparable val = property.func_185929_b(value).orElse(null);
                if (val == null) {
                    YungsApi.LOGGER.error("JSON: Found null for property {} for block {}", (Object)property, (Object)block.getRegistryName());
                    continue;
                }
                blockState = (BlockState)blockState.func_206870_a(property, val);
                found = true;
                break;
            }
            if (found) continue;
            YungsApi.LOGGER.error("JSON: Unable to find property {} for block {}", (Object)key, (Object)block.getRegistryName());
        }
        return blockState;
    }
}

