/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.api.energy.IEnergyConnector;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.page.panel.InfoBox;
import owmii.lib.config.IConfigHolder;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.item.IEnergyItemProvider;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.registry.IVariant;
import owmii.lib.util.Util;

public abstract class AbstractEnergyBlock<V extends Enum<V>, C extends IEnergyConfig<V>, B extends AbstractEnergyBlock<V, C, B>>
extends AbstractBlock<V, B>
implements IConfigHolder<V, C>,
InfoBox.IInfoBoxHolder,
IEnergyItemProvider {
    public AbstractEnergyBlock(AbstractBlock.Properties properties) {
        this(properties, (Enum)IVariant.getEmpty());
    }

    public AbstractEnergyBlock(AbstractBlock.Properties properties, V variant) {
        super(properties, (IVariant)variant);
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new EnergyBlockItem(this, properties, group);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractEnergyStorage) {
            return ((AbstractEnergyStorage)tile).getEnergy().toComparatorPower();
        }
        return super.func_180641_l(state, world, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (this.checkValidEnergySide()) {
            Direction side = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            BlockPos pos1 = pos.func_177972_a(side);
            return world.func_180495_p(pos1).func_177230_c() instanceof IEnergyConnector || Energy.isPresent(world.func_175625_s(pos1), side);
        }
        return super.func_196260_a(state, world, pos);
    }

    protected boolean checkValidEnergySide() {
        return false;
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return this.getTransferType().canReceive;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                this.addEnergyInfo(stack, energy, tooltip);
                this.addEnergyTransferInfo(stack, energy, tooltip);
                this.additionalEnergyInfo(stack, energy, tooltip);
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
        }));
    }

    public void addEnergyInfo(ItemStack stack, Energy.Item storage, List<ITextComponent> tooltip) {
        if (storage.getCapacity() > 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.stored").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.stored", new Object[]{Util.addCommas(storage.getStored()), Util.numFormat(storage.getCapacity())}).func_240699_a_(TextFormatting.DARK_GRAY)));
        }
    }

    public void addEnergyTransferInfo(ItemStack stack, Energy.Item storage, List<ITextComponent> tooltip) {
        long re;
        long ext = storage.getMaxExtract();
        if (ext + (re = storage.getMaxReceive()) > 0L) {
            if (ext == re) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.max.io").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat(ext)).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
            } else {
                if (ext > 0L) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.max.extract").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat(ext)).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
                }
                if (re > 0L) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.max.receive").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat(re)).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
                }
            }
        }
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                if (storage.getMaxEnergyStored() > 0) {
                    box.set((TextComponent)new TranslationTextComponent("info.lollipop.capacity"), (TextComponent)new TranslationTextComponent("info.lollipop.fe", new Object[]{Util.addCommas(energy.getCapacity())}));
                }
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.max.io"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(energy.getMaxExtract())}));
            }
        }));
        return box;
    }
}

