/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.Lollipop;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.client.screen.Texture;
import owmii.lib.client.screen.container.AbstractTileScreen;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.client.util.Text;
import owmii.lib.logistics.inventory.AbstractEnergyContainer;
import owmii.lib.network.packets.NextEnergyConfigPacket;

public class AbstractEnergyScreen<T extends AbstractEnergyStorage<?, ?, ?>, C extends AbstractEnergyContainer<T>>
extends AbstractTileScreen<T, C> {
    protected IconButton[] configButtons = new IconButton[6];
    protected IconButton configButtonAll = IconButton.EMPTY;

    public AbstractEnergyScreen(C container, PlayerInventory inv, ITextComponent title, Texture backGround) {
        super(container, inv, title, backGround);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.hasConfigButtons()) {
            this.addSideConfigButtons(0, 4);
        }
        if (this.hasRedstoneButton()) {
            this.addRedstoneButton(0, 31);
        }
    }

    protected void addSideConfigButtons(int x, int y) {
        for (int i = 0; i < 6; ++i) {
            int id = i;
            Pair<Integer, Integer> offset = this.getSideButtonOffsets(6).get(i);
            int xOffset = (Integer)offset.getLeft();
            int yOffset = (Integer)offset.getRight();
            Direction side = Direction.func_82600_a((int)i);
            this.configButtons[i] = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + xOffset + this.field_146999_f + x + 8, this.field_147009_r + yOffset + y + 10, Texture.CONFIG.get((Object)((AbstractEnergyStorage)this.te).getSideConfig().getType(side)), button -> {
                Lollipop.NET.toServer(new NextEnergyConfigPacket(id, ((AbstractEnergyStorage)this.te).func_174877_v()));
                ((AbstractEnergyStorage)this.te).getSideConfig().nextType(side);
            }, (Screen)this).setTooltip(tooltip -> {
                tooltip.add(new TranslationTextComponent("info.lollipop.facing").func_230529_a_((ITextComponent)Text.COLON).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.side." + side.func_176610_l()).func_240699_a_(TextFormatting.DARK_GRAY)));
                tooltip.add(((AbstractEnergyStorage)this.te).getSideConfig().getType(side).getDisplayName());
            }));
        }
        this.configButtonAll = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + this.field_146999_f + x + 14, this.field_147009_r + y + 4, Texture.CONFIG_BTN, button -> {
            Lollipop.NET.toServer(new NextEnergyConfigPacket(6, ((AbstractEnergyStorage)this.te).func_174877_v()));
            ((AbstractEnergyStorage)this.te).getSideConfig().nextTypeAll();
        }, (Screen)this).setTooltip(tooltip -> {
            tooltip.add(new TranslationTextComponent("info.lollipop.facing").func_230529_a_((ITextComponent)Text.COLON).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.all").func_240699_a_(TextFormatting.DARK_GRAY)));
            tooltip.add(((AbstractEnergyStorage)this.te).getSideConfig().getType(Direction.UP).getDisplayName());
        }));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.hasConfigButtons()) {
            for (int i = 0; i < 6; ++i) {
                this.configButtons[i].setTexture(Texture.CONFIG.get((Object)((AbstractEnergyStorage)this.te).getSideConfig().getType(Direction.func_82600_a((int)i))));
            }
        }
    }

    protected List<Pair<Integer, Integer>> getSideButtonOffsets(int spacing) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)0, (Object)spacing), Pair.of((Object)0, (Object)(-spacing)), Pair.of((Object)0, (Object)0), Pair.of((Object)spacing, (Object)spacing), Pair.of((Object)(-spacing), (Object)0), Pair.of((Object)spacing, (Object)0)});
    }

    @Override
    protected void drawBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(matrix, partialTicks, mouseX, mouseY);
        if (this.hasConfigButtons()) {
            Texture.CONFIG_BTN_BG.draw(matrix, this.configButtons[1].field_230690_l_ - 8, this.configButtons[1].field_230691_m_ - 4);
        }
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        List<Rectangle2d> extraAreas = super.getExtraAreas();
        if (this.hasConfigButtons()) {
            extraAreas.add(this.toRectangle2d(this.configButtons[1].field_230690_l_ - 8, this.configButtons[1].field_230691_m_ - 4, Texture.CONFIG_BTN_BG));
        }
        return extraAreas;
    }

    protected boolean hasConfigButtons() {
        return true;
    }

    protected boolean hasRedstoneButton() {
        return true;
    }
}

