/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.item.Stacks;
import owmii.lib.util.Util;

public class Inventory
extends ItemStackHandler {
    @Nullable
    private IInventoryHolder tile;

    public Inventory(int size) {
        this(size, null);
    }

    public Inventory(Stacks stacks) {
        this(stacks, null);
    }

    public Inventory(Stacks stacks, @Nullable IInventoryHolder tile) {
        super((NonNullList)stacks);
        this.tile = tile;
    }

    Inventory(int size, @Nullable IInventoryHolder tile) {
        super(size);
        this.tile = tile;
    }

    public static <I extends AbstractTileEntity> Inventory create(int size, @Nullable I tile) {
        return new Inventory(size, (IInventoryHolder)((Object)tile));
    }

    public static <I extends AbstractTileEntity> Inventory createBlank(@Nullable I tile) {
        return new Inventory(0, (IInventoryHolder)((Object)tile));
    }

    public static Inventory create(int size) {
        return new Inventory(size, null);
    }

    public static Inventory createBlank() {
        return new Inventory(0, null);
    }

    public void setTile(@Nullable IInventoryHolder tile) {
        this.tile = tile;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.isBlank()) {
            return;
        }
        nbt.func_74768_a("Size", this.getSlots());
        super.deserializeNBT(nbt);
    }

    public CompoundNBT serializeNBT() {
        return this.isBlank() ? new CompoundNBT() : super.serializeNBT();
    }

    public Inventory set(int size) {
        this.stacks = Stacks.withSize(size, ItemStack.field_190927_a);
        this.onContentsChanged(0);
        return this;
    }

    public Inventory add(int size) {
        this.stacks = Stacks.withSize(size + this.stacks.size(), ItemStack.field_190927_a);
        return this;
    }

    public Stacks canPut(Stacks outputs, int ... slots) {
        return this.canPut(outputs, this.fromSlotArray(slots));
    }

    public Stacks canPut(Stacks outputs, Stacks slots) {
        Inventory inv = new Inventory(Stacks.from(slots).copy());
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack.func_77946_l(), (boolean)false).func_190926_b()) continue;
            return Stacks.create();
        }
        return inv.getStacks();
    }

    public Stacks fromSlotArray(int ... slots) {
        Stacks stacks = Stacks.create();
        for (int i : slots) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    public int getSlotLimit(int slot) {
        if (this.tile != null) {
            return this.tile.getSlotLimit(slot);
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canInsert(slot, stack);
        }
        return super.isItemValid(slot, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.canExtract(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public ItemStack extractItemFromSlot(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canExtract(slot, stack);
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        if (this.tile != null) {
            this.tile.onSlotChanged(slot);
        }
    }

    public ItemStack getFirst() {
        return this.getStackInSlot(0);
    }

    public ItemStack getLast() {
        return this.getStackInSlot(this.getLastSlot());
    }

    public int getLastSlot() {
        return this.getSlots() - 1;
    }

    public Stacks getLast(int count) {
        Stacks stacks = Stacks.create();
        int size = this.stacks.size();
        for (int i = size - count; i < count; ++i) {
            stacks.add(this.stacks.get(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (ItemStack stack : this.stacks) {
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotEmpty(int slot) {
        return ((ItemStack)this.stacks.get(slot)).func_190926_b();
    }

    public ItemStack setSlotEmpty(int slot) {
        ItemStack stack = (ItemStack)this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        this.onContentsChanged(slot);
        return stack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack stack1 = (ItemStack)this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void clear() {
        this.set(this.getSlots());
    }

    public boolean isBlank() {
        return this.stacks.size() <= 0;
    }

    public Stacks getStacks() {
        return Stacks.from((NonNullList<ItemStack>)this.stacks);
    }

    public List<ItemStack> getNonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        stacks.removeIf(ItemStack::func_190926_b);
        return stacks;
    }

    public ItemStack addNext(ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            this.insertItem(i, stack.func_77946_l(), false);
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeNext() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.setSlotEmpty(i);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate, int ... ex) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (Util.anyMatch(ex, i) || !(stack = this.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public void drop(World world, BlockPos pos) {
        this.stacks.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        this.clear();
    }

    public void drop(int index, World world, BlockPos pos) {
        ItemStack stack = this.getStackInSlot(index);
        if (!stack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            this.setStackInSlot(index, ItemStack.field_190927_a);
        }
    }

    public static Inventory from(final IItemHandler handler) {
        Inventory inventory = new Inventory(handler.getSlots()){

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, true);
            }

            @Override
            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }
        };
        return inventory;
    }

    public static Stacks toList(IItemHandler handler) {
        Stacks stacks = Stacks.withSize(handler.getSlots(), ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.set(i, handler.getStackInSlot(i));
        }
        return stacks;
    }

    public static LazyOptional<IItemHandler> get(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null ? te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : LazyOptional.empty();
    }

    public static int calcRedstone(IItemHandler inv) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

