/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.network.IPacket;

public class NextEnergyConfigPacket
implements IPacket<NextEnergyConfigPacket> {
    private int mode;
    private BlockPos pos;

    public NextEnergyConfigPacket(int mode, BlockPos pos) {
        this.mode = mode;
        this.pos = pos;
    }

    public NextEnergyConfigPacket() {
        this(0, BlockPos.field_177992_a);
    }

    @Override
    public void encode(NextEnergyConfigPacket msg, PacketBuffer buffer) {
        buffer.writeInt(msg.mode);
        buffer.func_179255_a(msg.pos);
    }

    @Override
    public NextEnergyConfigPacket decode(PacketBuffer buffer) {
        return new NextEnergyConfigPacket(buffer.readInt(), buffer.func_179259_c());
    }

    @Override
    public void handle(NextEnergyConfigPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (tileEntity = player.field_70170_p.func_175625_s(msg.pos)) instanceof AbstractEnergyStorage) {
                AbstractEnergyStorage storage = (AbstractEnergyStorage)tileEntity;
                if (msg.mode > 5) {
                    storage.getSideConfig().nextTypeAll();
                } else {
                    storage.getSideConfig().nextType(Direction.func_82600_a((int)msg.mode));
                }
                storage.sync();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

