/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util.dev;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import owmii.lib.registry.Registry;

public class DevUtil {
    public static void genItemModels(Registry<? extends Item> registry) {
        registry.forEach(item -> DevUtil.genItemModel(item.getRegistryName()));
    }

    public static void genItemModel(@Nullable ResourceLocation location) {
        if (location != null) {
            String domain = location.func_110624_b();
            String name = location.func_110623_a();
            IModInfo info = (IModInfo)ModList.get().getModFileById(domain).getMods().get(0);
            String jsonString = "{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n\t\"layer0\": \"" + domain + ":item/" + name + "\"\n  }\n}";
            Path path = Paths.get(FMLPaths.GAMEDIR.get().toAbsolutePath().toString(), "../../../" + info.getDisplayName() + "/src/main/resources/assets/" + domain + "/models/item/" + name + ".json");
            if (!path.toFile().exists()) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(jsonString);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

