/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.client.tileentity;

import com.minecraftabnormals.upgrade_aquatic.client.model.ElderEyeModel;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.ElderEyeBlock;
import com.minecraftabnormals.upgrade_aquatic.common.tileentities.ElderEyeTileEntity;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ElderEyeTileEntityRenderer
extends TileEntityRenderer<ElderEyeTileEntity> {
    private static final ResourceLocation ELDER_EYE_TEXTURE = new ResourceLocation("upgrade_aquatic:textures/tile/guardian_eye.png");
    private static final ResourceLocation ELDER_EYE_DIM_TEXTURE = new ResourceLocation("upgrade_aquatic:textures/tile/guardian_eye_dim.png");
    private final ElderEyeModel model = new ElderEyeModel();

    public ElderEyeTileEntityRenderer(TileEntityRendererDispatcher renderDispatcher) {
        super(renderDispatcher);
    }

    public void render(ElderEyeTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        BlockState eyeState = te.func_145830_o() ? te.func_195044_w() : ((Block)UABlocks.ELDER_EYE.get()).func_176223_P();
        Direction facing = (Direction)eyeState.func_177229_b((Property)ElderEyeBlock.field_176387_N);
        if (facing == Direction.DOWN) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, 1.25, 0.75);
        } else if (facing == Direction.UP) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227861_a_(0.0, 1.25, -1.25);
        } else if (facing == Direction.NORTH) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        } else if (facing == Direction.EAST) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        } else if (facing == Direction.WEST) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        }
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getEyeTexture((Boolean)eyeState.func_177229_b((Property)ElderEyeBlock.ACTIVE))));
        this.model.render(matrixStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private ResourceLocation getEyeTexture(boolean active) {
        return active ? ELDER_EYE_TEXTURE : ELDER_EYE_DIM_TEXTURE;
    }
}

