/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.pike;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;

public enum PikeType {
    AMUR(1, PikeSize.SMALL, PikeRarity.UNCOMMON, null, Biome.Category.SWAMP),
    REDFIN(2, PikeSize.SMALL, PikeRarity.COMMON, null, null),
    BROWN_NORTHERN(3, PikeSize.LARGE, PikeRarity.COMMON, 8, null),
    MAHOGANY_NORTHERN(4, PikeSize.LARGE, PikeRarity.UNCOMMON, 9, null),
    JADE_NORTHERN(5, PikeSize.LARGE, PikeRarity.RARE, 10, null),
    OLIVE_NORTHERN(6, PikeSize.LARGE, PikeRarity.SUPER_RARE, 11, null),
    SPECTRAL(7, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    SPOTTED_BROWN_NORTHERN(8, PikeSize.LARGE, PikeRarity.COMMON, null, null),
    SPOTTED_MAHOGANY_NORTHERN(9, PikeSize.LARGE, PikeRarity.UNCOMMON, null, null),
    SPOTTED_JADE_NORTHERN(10, PikeSize.LARGE, PikeRarity.RARE, null, null),
    SPOTTED_OLIVE_NORTHERN(11, PikeSize.LARGE, PikeRarity.SUPER_RARE, null, null),
    SUPERCHARGED(12, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    OBSIDIAN(13, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    MUSKELLUNGE(14, PikeSize.HUGE, PikeRarity.SUPER_RARE, null, Biome.Category.RIVER),
    CHAIN_PICKEREL(15, PikeSize.SMALL, PikeRarity.COMMON, null, Biome.Category.RIVER),
    GRASS_PICKEREL(16, PikeSize.SMALL, PikeRarity.COMMON, null, Biome.Category.SWAMP),
    BLACK_SOUTHERN(17, PikeSize.MEDIUM, PikeRarity.COMMON, null, null),
    EBONY_SOUTHERN(18, PikeSize.MEDIUM, PikeRarity.UNCOMMON, null, null),
    MUSTARD_SOUTHERN(19, PikeSize.MEDIUM, PikeRarity.RARE, null, null),
    LEMON_SOUTHERN(20, PikeSize.MEDIUM, PikeRarity.RARE, null, null),
    GOLDEN_SOUTHERN(21, PikeSize.MEDIUM, PikeRarity.SUPER_RARE, null, null);

    public final int id;
    public final PikeSize pikeSize;
    public final PikeRarity rarity;
    @Nullable
    private final Integer spottedVariant;
    @Nullable
    private final Biome.Category biomeCategory;

    private PikeType(int id, @Nullable PikeSize pikeSize, @Nullable PikeRarity rarity, Integer spottedVariant, Biome.Category biomeCategory) {
        this.id = id;
        this.pikeSize = pikeSize;
        this.rarity = rarity;
        this.spottedVariant = spottedVariant;
        this.biomeCategory = biomeCategory;
    }

    public static PikeType getTypeById(int id) {
        for (PikeType type : PikeType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return AMUR;
    }

    public static PikeType getRandom(Random rand, Biome.Category category, boolean fromBucket) {
        WeightedList possibleRarityTypes = (WeightedList)Util.func_200696_a((Object)new WeightedList(), list -> {
            for (PikeRarity rarity : PikeRarity.values()) {
                list.func_226313_a_(PikeType.getTypeList(category, rarity, fromBucket), rarity.weight);
            }
        });
        List possibleTypes = (List)possibleRarityTypes.func_226318_b_(rand);
        PikeType type = (PikeType)((Object)possibleTypes.get(rand.nextInt(possibleTypes.size())));
        Integer spottedVariant = type.spottedVariant;
        return spottedVariant != null && rand.nextFloat() < 0.2f ? PikeType.getTypeById(spottedVariant) : type;
    }

    private static List<PikeType> getTypeList(Biome.Category category, PikeRarity rarity, boolean fromBucket) {
        ArrayList pikeTypes = Lists.newArrayList();
        ArrayList spotted = Lists.newArrayList();
        for (PikeType type : PikeType.values()) {
            if (!fromBucket && type.biomeCategory != null && type.biomeCategory != category || type.rarity != rarity || spotted.contains((Object)type)) continue;
            Integer spottedVariant = type.spottedVariant;
            if (spottedVariant != null) {
                spotted.add(PikeType.getTypeById(spottedVariant));
            }
            pikeTypes.add(type);
        }
        return pikeTypes;
    }

    public static enum PikeRarity {
        COMMON(TextFormatting.GRAY, 55),
        UNCOMMON(TextFormatting.GREEN, 25),
        RARE(TextFormatting.BLUE, 15),
        SUPER_RARE(TextFormatting.GOLD, 5),
        LEGENDARY(TextFormatting.LIGHT_PURPLE, 1);

        public final TextFormatting formatting;
        private final int weight;

        private PikeRarity(TextFormatting formatting, int weight) {
            this.formatting = formatting;
            this.weight = weight;
        }
    }

    public static enum PikeSize {
        SMALL(1.2f, 1.4f),
        MEDIUM(1.5f, 1.7f),
        LARGE(1.7f, 1.9f),
        HUGE(2.3f, 2.5f);

        public final float renderSize;
        public final float boxSize;

        private PikeSize(float renderSize, float boxSize) {
            this.renderSize = renderSize;
            this.boxSize = boxSize;
        }
    }
}

