/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.network;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class RotateJellyfishMessage {
    private final int entityId;
    private final int tickLength;
    private final float yaw;
    private final float pitch;

    public RotateJellyfishMessage(int entityId, int tickLength, float yaw, float pitch) {
        this.entityId = entityId;
        this.tickLength = tickLength;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.tickLength);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
    }

    public static RotateJellyfishMessage deserialize(PacketBuffer buf) {
        return new RotateJellyfishMessage(buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(RotateJellyfishMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = ClientInfo.getClientPlayerWorld().func_73045_a(message.entityId);
                if (entity instanceof AbstractJellyfishEntity) {
                    ((AbstractJellyfishEntity)entity).getRotationController().rotate(message.yaw, message.pitch, message.tickLength);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

