/*
 * Decompiled with CFR 0.152.
 */
package lazy.baublesinterface;

import com.mojang.datafixers.util.Pair;
import lazy.baubles.api.BaublesAPI;
import lazy.baubles.api.cap.IBaublesItemHandler;
import lazy.baublesinterface.InterfaceConfigs;
import lazy.baublesinterface.InterfacePosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class InterfaceRenderer {
    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!((Boolean)InterfaceConfigs.ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            InterfaceRenderer.renderInterface(event.getWindow().func_198107_o(), event.getWindow().func_198087_p());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderInterface(int gsWidth, int gsHeight) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            IBaublesItemHandler baublesInv = (IBaublesItemHandler)BaublesAPI.getBaublesHandler((PlayerEntity)player).orElseThrow(NullPointerException::new);
            int xOff = 0;
            int yOff = 0;
            int size = 64;
            Pair<Integer, Integer> startPos = InterfaceRenderer.resolveStartPos(gsWidth, gsHeight, size);
            if (((Boolean)InterfaceConfigs.VERTICAL.get()).booleanValue()) {
                yOff = 16;
            } else {
                xOff = 16;
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack stackInSlot = baublesInv.getStackInSlot(i);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(stackInSlot, (Integer)startPos.getFirst() + xOff * i, (Integer)startPos.getSecond() + yOff * i);
                Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stackInSlot, (Integer)startPos.getFirst() + xOff * i, (Integer)startPos.getSecond() + yOff * i);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Pair<Integer, Integer> resolveStartPos(int gsWidth, int gsHeight, int size) {
        int startX = 0;
        int startY = 0;
        boolean vertical = (Boolean)InterfaceConfigs.VERTICAL.get();
        int margin = (Integer)InterfaceConfigs.INTERFACE_MARGIN.get();
        switch ((InterfacePosition)((Object)InterfaceConfigs.INTERFACE_POSITION.get())) {
            case TOP_LEFT: {
                startX = margin;
                startY = margin;
                break;
            }
            case BOTTOM_LEFT: {
                startX = margin;
                if (vertical) {
                    startY = gsHeight - size - margin;
                    break;
                }
                startY = gsHeight - 16 - margin;
                break;
            }
            case TOP_RIGHT: {
                startY = margin;
                if (vertical) {
                    startX = gsWidth - 16 - margin;
                    break;
                }
                startX = gsWidth - size - margin;
                break;
            }
            case BOTTOM_RIGHT: {
                if (vertical) {
                    startX = gsWidth - 16 - margin;
                    startY = gsHeight - size - margin;
                    break;
                }
                startX = gsWidth - size - margin;
                startY = gsHeight - 16 - margin;
            }
        }
        return new Pair((Object)startX, (Object)startY);
    }
}

