/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class ReactiveEnchantmentRecipe
extends EnchantmentRecipe {
    public ReactiveEnchantmentRecipe(ItemStack[] pedestalItems, int manaCost) {
        super(pedestalItems, (Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, 1, manaCost);
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable PlayerEntity player) {
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(pedestalItems);
        return super.isMatch(pedestalItems, reagent, enchantingApparatusTile, player) && !parchment.func_190926_b() && !SpellParchment.getSpell(parchment).isEmpty();
    }

    @Nonnull
    public static ItemStack getParchment(List<ItemStack> pedestalItems) {
        for (ItemStack stack : pedestalItems) {
            if (!(stack.func_77973_b() instanceof SpellParchment)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        ItemStack stack = super.getResult(pedestalItems, reagent, enchantingApparatusTile);
        CompoundNBT tag = stack.func_196082_o();
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(pedestalItems);
        tag.func_74778_a("spell", SpellParchment.getSpell(parchment).serialize());
        tag.func_74778_a("spell_color", SpellCaster.deserialize(parchment).getColor().serialize());
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return new ResourceLocation("ars_nouveau", "reactive");
    }
}

