/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChimeraSummonEvent
implements ITimedEvent {
    int duration;
    int phase;
    World world;
    BlockPos pos;
    int ownerID;
    public static final String ID = "chimera";

    public ChimeraSummonEvent(int duration, int phase, World world, BlockPos pos, int ownerID) {
        this.duration = duration;
        this.phase = phase;
        this.world = world;
        this.pos = pos;
        this.ownerID = ownerID;
    }

    public static ChimeraSummonEvent get(CompoundNBT tag) {
        return new ChimeraSummonEvent(tag.func_74762_e("duration"), tag.func_74762_e("phase"), ArsNouveau.proxy.getClientWorld(), NBTUtil.getBlockPos(tag, "loc"), -1);
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (serverSide) {
            Entity owner = this.world.func_73045_a(this.ownerID);
            if (!(owner instanceof EntityChimera)) {
                this.duration = 0;
                return;
            }
            EntityChimera boss = (EntityChimera)owner;
            boolean summonedWilden = false;
            if (this.duration % 20 == 0) {
                Random random = boss.func_70681_au();
                SummonWolf wolf = new SummonWolf(ModEntities.SUMMON_WOLF, this.world);
                wolf.func_70107_b(this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p());
                wolf.isWildenSummon = true;
                wolf.ticksLeft = 100 + this.phase * 60;
                this.summon((MobEntity)wolf, this.getPos(), boss.func_70638_az());
                int randBound = 10 - boss.getPhase();
                if (!summonedWilden && boss.hasWings() && boss.field_70170_p.field_73012_v.nextInt(randBound) == 0) {
                    WildenStalker stalker = new WildenStalker(ModEntities.WILDEN_STALKER, this.world);
                    this.summon((MobEntity)stalker, this.getPos(), boss.func_70638_az());
                    summonedWilden = true;
                }
                if (boss.hasHorns() && boss.field_70170_p.field_73012_v.nextInt(randBound) == 0) {
                    WildenHunter hunter = new WildenHunter(ModEntities.WILDEN_HUNTER, this.world);
                    this.summon((MobEntity)hunter, this.getPos(), boss.func_70638_az());
                    summonedWilden = true;
                }
                if (!summonedWilden && boss.hasSpikes() && boss.field_70170_p.field_73012_v.nextInt(randBound) == 0) {
                    WildenGuardian guardian = new WildenGuardian(ModEntities.WILDEN_GUARDIAN, this.world);
                    this.summon((MobEntity)guardian, this.getPos(), boss.func_70638_az());
                    summonedWilden = true;
                }
            }
        } else {
            ParticleUtil.spawnRitualAreaEffect(this.pos, this.world, this.world.field_73012_v, ParticleUtil.defaultParticleColor(), 1 + this.phase * 2);
        }
    }

    public void summon(MobEntity mob, BlockPos pos, @Nullable LivingEntity target) {
        mob.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        mob.func_70624_b(target);
        mob.func_213395_q(true);
        mob.field_70170_p.func_217376_c((Entity)mob);
    }

    public BlockPos getPos() {
        double spawnArea = 2.5 + (double)(this.phase * 2);
        return new BlockPos((double)this.pos.func_177958_n() + ParticleUtil.inRange(-spawnArea, spawnArea), (double)(this.pos.func_177956_o() + 2), (double)this.pos.func_177952_p() + ParticleUtil.inRange(-spawnArea, spawnArea));
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0;
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        ITimedEvent.super.serialize(tag);
        tag.func_74768_a("duration", this.duration);
        tag.func_74768_a("phase", this.phase);
        NBTUtil.storeBlockPos(tag, "loc", this.pos);
        return tag;
    }

    @Override
    public String getID() {
        return ID;
    }
}

