/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractEffect
extends AbstractSpellPart {
    protected Set<AbstractAugment> POTION_AUGMENTS = this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE);
    protected Set<AbstractAugment> SUMMON_AUGMENTS = this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    public ForgeConfigSpec.DoubleValue DAMAGE;
    public ForgeConfigSpec.DoubleValue AMP_VALUE;
    public ForgeConfigSpec.IntValue POTION_TIME;
    public ForgeConfigSpec.IntValue EXTEND_TIME;
    public ForgeConfigSpec.IntValue GENERIC_INT;
    public ForgeConfigSpec.DoubleValue GENERIC_DOUBLE;

    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    @Deprecated
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            this.onResolveBlock((BlockRayTraceResult)rayTraceResult, world, shooter, new SpellStats.Builder().setAugments(augments).addItemsFromEntity(shooter).build(this, rayTraceResult, world, shooter, spellContext), spellContext);
        }
        if (rayTraceResult instanceof EntityRayTraceResult) {
            this.onResolveEntity((EntityRayTraceResult)rayTraceResult, world, shooter, new SpellStats.Builder().setAugments(augments).addItemsFromEntity(shooter).build(this, rayTraceResult, world, shooter, spellContext), spellContext);
        }
    }

    @Deprecated
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
    }

    @Deprecated
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
    }

    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        this.onResolve(rayTraceResult, world, shooter, spellStats.getAugments(), spellContext);
    }

    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        this.onResolveEntity(rayTraceResult, world, shooter, spellStats.getAugments(), spellContext);
    }

    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        this.onResolveBlock(rayTraceResult, world, shooter, spellStats.getAugments(), spellContext);
    }

    @Deprecated
    public void applyPotion(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes) {
        this.applyPotion(entity, potionEffect, augmentTypes, 30, 8);
    }

    @Deprecated
    public void applyConfigPotion(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes) {
        this.applyPotion(entity, potionEffect, augmentTypes, this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get(), this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get());
    }

    public void applyConfigPotion(LivingEntity entity, Effect potionEffect, SpellStats spellStats) {
        this.applyConfigPotion(entity, potionEffect, spellStats, true);
    }

    public void applyConfigPotion(LivingEntity entity, Effect potionEffect, SpellStats spellStats, boolean showParticles) {
        this.applyPotion(entity, potionEffect, spellStats, this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get(), this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get(), showParticles);
    }

    public boolean canSummon(LivingEntity playerEntity) {
        return this.isRealPlayer(playerEntity) && playerEntity.func_70660_b((Effect)ModPotions.SUMMONING_SICKNESS) == null;
    }

    public void applySummoningSickness(LivingEntity playerEntity, int time) {
        playerEntity.func_195064_c(new EffectInstance((Effect)ModPotions.SUMMONING_SICKNESS, time));
    }

    public void summonLivingEntity(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats augments, SpellContext spellContext, ISummon summon) {
        if (shooter != null) {
            summon.setOwnerID(shooter.func_110124_au());
        }
        if (summon.getLivingEntity() != null) {
            world.func_217376_c((Entity)summon.getLivingEntity());
        }
        MinecraftForge.EVENT_BUS.post((Event)new SummonEvent(rayTraceResult, world, shooter, augments, spellContext, summon));
    }

    @Deprecated
    public void applyPotionWithCap(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes, int baseDuration, int durationBuffBase, int cap) {
        if (entity == null) {
            return;
        }
        int duration = baseDuration + durationBuffBase * this.getDurationModifier(augmentTypes);
        int amp = Math.min(cap, this.getAmplificationBonus(augmentTypes));
        entity.func_195064_c(new EffectInstance(potionEffect, duration * 20, amp));
    }

    public void applyPotionWithCap(LivingEntity entity, Effect potionEffect, SpellStats stats, int baseDuration, int durationBuffBase, int cap) {
        if (entity == null) {
            return;
        }
        int duration = (int)((double)baseDuration + (double)durationBuffBase * stats.getDurationMultiplier());
        int amp = Math.min(cap, (int)stats.getAmpMultiplier());
        entity.func_195064_c(new EffectInstance(potionEffect, duration * 20, amp));
    }

    @Deprecated
    public void applyPotion(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes, int baseDuration, int durationBuffBase) {
        if (entity == null) {
            return;
        }
        int duration = baseDuration + durationBuffBase * this.getDurationModifier(augmentTypes);
        int amp = this.getAmplificationBonus(augmentTypes);
        entity.func_195064_c(new EffectInstance(potionEffect, duration * 20, amp));
    }

    public void applyPotion(LivingEntity entity, Effect potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.func_195064_c(new EffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    @Deprecated
    public int getDurationModifier(List<AbstractAugment> augmentTypes) {
        return AbstractEffect.getBuffCount(augmentTypes, AugmentExtendTime.class) - AbstractEffect.getBuffCount(augmentTypes, AugmentDurationDown.class);
    }

    public PlayerEntity getPlayer(LivingEntity entity, ServerWorld world) {
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : FakePlayerFactory.getMinecraft((ServerWorld)world);
    }

    @Deprecated
    public int getBaseHarvestLevel(List<AbstractAugment> augments) {
        return 2 + this.getAmplificationBonus(augments);
    }

    public boolean canBlockBeHarvested(List<AbstractAugment> augments, World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f && this.getBaseHarvestLevel(augments) >= world.func_180495_p(pos).getHarvestLevel();
    }

    public int getBaseHarvestLevel(SpellStats stats) {
        return (int)(2.0 + stats.getAmpMultiplier());
    }

    public boolean canBlockBeHarvested(SpellStats stats, World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f && this.getBaseHarvestLevel(stats) >= world.func_180495_p(pos).getHarvestLevel();
    }

    public void dealDamage(World world, LivingEntity shooter, float baseDamage, SpellStats stats, Entity entity, DamageSource source) {
        Object playerContext;
        shooter = shooter == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)) : shooter;
        float totalDamage = (float)((double)baseDamage + stats.getDamageModifier());
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() <= 0.0f || totalDamage <= 0.0f) {
            return;
        }
        entity.func_70097_a(source, totalDamage);
        Object object = playerContext = shooter instanceof PlayerEntity ? (PlayerEntity)shooter : ANFakePlayer.getPlayer((ServerWorld)world);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (mob.func_110143_aJ() <= 0.0f && !mob.field_70128_L && stats.hasBuff(AugmentFortune.INSTANCE)) {
            int looting = stats.getBuffCount(AugmentFortune.INSTANCE);
            LootContext.Builder lootContext = LootUtil.getLootingContext((ServerWorld)world, shooter, mob, looting, DamageSource.func_76365_a((PlayerEntity)playerContext));
            ResourceLocation lootTable = mob.func_213346_cF();
            LootTable loottable = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
            List items = loottable.func_216113_a(lootContext.func_216022_a(LootParameterSets.field_216266_g));
            items.forEach(arg_0 -> ((LivingEntity)mob).func_199701_a_(arg_0));
        }
    }

    @Deprecated
    public void dealDamage(World world, LivingEntity shooter, float damage, List<AbstractAugment> augments, Entity entity, DamageSource source) {
        Object object = shooter = shooter == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)) : shooter;
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() <= 0.0f || damage <= 0.0f) {
            return;
        }
        entity.func_70097_a(source, damage);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (mob.func_110143_aJ() <= 0.0f && !mob.field_70128_L && this.hasBuff(augments, AugmentFortune.class)) {
            int looting = AbstractEffect.getBuffCount(augments, AugmentFortune.class);
            LootContext.Builder lootContext = LootUtil.getLootingContext((ServerWorld)world, shooter, mob, looting, DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)shooter)));
            ResourceLocation lootTable = mob.func_213346_cF();
            LootTable loottable = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
            List items = loottable.func_216113_a(lootContext.func_216022_a(LootParameterSets.field_216266_g));
            items.forEach(arg_0 -> ((LivingEntity)mob).func_199701_a_(arg_0));
        }
    }

    public DamageSource buildDamageSource(World world, LivingEntity shooter) {
        shooter = !(shooter instanceof PlayerEntity) ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)) : shooter;
        return DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)shooter));
    }

    public Vector3d safelyGetHitPos(RayTraceResult result) {
        return result instanceof EntityRayTraceResult ? ((EntityRayTraceResult)result).func_216348_a().func_213303_ch() : result.func_216347_e();
    }

    public boolean isRealPlayer(LivingEntity entity) {
        return entity instanceof PlayerEntity && this.isNotFakePlayer(entity);
    }

    public boolean isNotFakePlayer(LivingEntity entity) {
        return !(entity instanceof FakePlayer);
    }

    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return true;
    }

    public boolean nonAirBlockSuccess(RayTraceResult rayTraceResult, World world) {
        return rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_185904_a() != Material.field_151579_a;
    }

    public boolean livingEntityHitSuccess(RayTraceResult rayTraceResult) {
        return rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity;
    }

    public boolean nonAirAnythingSuccess(RayTraceResult result, World world) {
        return this.nonAirBlockSuccess(result, world) || this.livingEntityHitSuccess(result);
    }

    public void applyEnchantments(List<AbstractAugment> augments, ItemStack stack) {
        if (this.hasBuff(augments, AugmentExtract.class)) {
            stack.func_77966_a(Enchantments.field_185306_r, 1);
        }
        if (this.hasBuff(augments, AugmentFortune.class)) {
            stack.func_77966_a(Enchantments.field_185308_t, AbstractEffect.getBuffCount(augments, AugmentFortune.class));
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        super.buildAugmentLimitsConfig(builder, this.getDefaultAugmentLimits());
    }

    public void addDamageConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.DAMAGE = builder.defineInRange("damage", defaultValue, 0.0, 2.147483647E9);
    }

    public void addAmpConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.AMP_VALUE = builder.defineInRange("amplify", defaultValue, 0.0, 2.147483647E9);
    }

    public void addPotionConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.POTION_TIME = builder.comment("Potion duration, in seconds").defineInRange("potion_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addExtendTimeConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.EXTEND_TIME = builder.comment("Extend time duration, in seconds").defineInRange("extend_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addGenericInt(ForgeConfigSpec.Builder builder, int val, String comment, String path) {
        this.GENERIC_INT = builder.comment(comment).defineInRange(path, val, 0, Integer.MAX_VALUE);
    }

    public void addGenericDouble(ForgeConfigSpec.Builder builder, double val, String comment, String path) {
        this.GENERIC_DOUBLE = builder.comment(comment).defineInRange(path, val, 0.0, Double.MAX_VALUE);
    }

    public void addDefaultPotionConfig(ForgeConfigSpec.Builder builder) {
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    public ItemStack getItemFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate) {
        if (spellContext.castingTile instanceof IInventoryResponder) {
            return ((IInventoryResponder)spellContext.castingTile).getItem(predicate);
        }
        if (shooter instanceof IInventoryResponder) {
            return ((IInventoryResponder)shooter).getItem(predicate);
        }
        if (shooter instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            NonNullList list = playerEntity.field_71071_by.field_70462_a;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getItemFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Item item) {
        return this.getItemFromCaster(shooter, spellContext, (ItemStack i) -> i.func_77969_a(new ItemStack((IItemProvider)item)));
    }

    public ItemStack extractStackFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate, int maxExtract) {
        IInventoryResponder responder = null;
        if (spellContext.castingTile instanceof IInventoryResponder) {
            responder = (IInventoryResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IInventoryResponder)shooter;
        }
        if (responder != null) {
            return responder.extractItem(predicate, maxExtract);
        }
        if (shooter instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            NonNullList list = playerEntity.field_71071_by.field_70462_a;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack.func_77979_a(maxExtract);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertStackToCaster(@Nullable LivingEntity shooter, SpellContext spellContext, ItemStack stack) {
        IPickupResponder responder = null;
        if (spellContext.castingTile instanceof IPickupResponder) {
            responder = (IPickupResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IPickupResponder)shooter;
        }
        if (responder != null) {
            return responder.onPickup(stack);
        }
        if (this.isRealPlayer(shooter)) {
            PlayerEntity player = (PlayerEntity)shooter;
            VoidJar.tryVoiding(player, stack);
            if (!player.func_191521_c(stack)) {
                ItemEntity i = new ItemEntity(shooter.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                shooter.field_70170_p.func_217376_c((Entity)i);
            }
        }
        return stack;
    }
}

