/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IMana;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.armor.MagicArmor;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ManaUtil {
    public static int getPlayerDiscounts(LivingEntity e) {
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                discounts.addAndGet(((IManaEquipment)item).getManaDiscount(items.getStackInSlot(i)));
            }
        });
        return discounts.get();
    }

    public static int getMaxMana(PlayerEntity e) {
        IMana mana = (IMana)ManaCapability.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0;
        }
        int max = (Integer)Config.INIT_MAX_MANA.get();
        for (ItemStack i : e.func_184209_aF()) {
            if (i.func_77973_b() instanceof IManaEquipment) {
                max += ((IManaEquipment)i.func_77973_b()).getMaxManaBoost(i);
            }
            max += (Integer)Config.MANA_BOOST_BONUS.get() * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, (ItemStack)i);
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                max += ((IManaEquipment)item).getMaxManaBoost(items.getStackInSlot(i));
            }
        }
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus() > 5 ? mana.getGlyphBonus() - 5 : 0;
        max += numGlyphs * (Integer)Config.GLYPH_MAX_BONUS.get();
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max += tier * (Integer)Config.TIER_MAX_BONUS.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        return max;
    }

    public static double getManaRegen(PlayerEntity e) {
        IMana mana = (IMana)ManaCapability.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = ((Integer)Config.INIT_MANA_REGEN.get()).intValue();
        for (ItemStack i : e.func_184209_aF()) {
            if (i.func_77973_b() instanceof MagicArmor) {
                MagicArmor armor = (MagicArmor)i.func_77973_b();
                regen += (double)armor.getManaRegenBonus(i);
            }
            regen += (double)((Integer)Config.MANA_REGEN_ENCHANT_BONUS.get() * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, (ItemStack)i));
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                regen += (double)((IManaEquipment)item).getManaRegenBonus(items.getStackInSlot(i));
            }
        }
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus() > 5 ? (double)(mana.getGlyphBonus() - 5) : 0.0;
        regen += numGlyphs * (Double)Config.GLYPH_REGEN_BONUS.get();
        regen += (double)tier;
        if (e.func_70660_b((Effect)ModPotions.MANA_REGEN_EFFECT) != null) {
            regen += (double)((Integer)Config.MANA_REGEN_POTION.get() * (1 + e.func_70660_b((Effect)ModPotions.MANA_REGEN_EFFECT).func_76458_c()));
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }

    @Nullable
    public static BlockPos takeManaNearby(BlockPos pos, World world, int range, int mana) {
        Optional loc = BlockPos.func_239584_a_((BlockPos)pos, (int)range, (int)range, b -> world.func_175625_s(b) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(b)).getCurrentMana() >= mana);
        if (!loc.isPresent()) {
            return null;
        }
        ManaJarTile tile = (ManaJarTile)world.func_175625_s((BlockPos)loc.get());
        tile.removeMana(mana);
        return (BlockPos)loc.get();
    }

    @Nullable
    public static BlockPos takeManaNearbyWithParticles(BlockPos pos, World world, int range, int mana) {
        BlockPos result = ManaUtil.takeManaNearby(pos, world, range, mana);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, result, pos);
            world.func_217376_c((Entity)aoeProjectile);
        }
        return result;
    }

    public static boolean hasManaNearby(BlockPos pos, World world, int range, int mana) {
        Optional loc = BlockPos.func_239584_a_((BlockPos)pos, (int)range, (int)range, b -> world.func_175625_s(b) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(b)).getCurrentMana() >= mana);
        return loc.isPresent();
    }

    @Nullable
    public static BlockPos canGiveManaClosest(BlockPos pos, World world, int range) {
        Optional loc = BlockPos.func_239584_a_((BlockPos)pos, (int)range, (int)range, b -> world.func_175625_s(b) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(b)).canAcceptMana());
        return loc.orElse(null);
    }

    public static List<BlockPos> canGiveManaAny(BlockPos pos, World world, int range) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.func_239588_b_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            if (world.func_175625_s(b) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(b)).canAcceptMana()) {
                posList.add(b.func_185334_h());
            }
        });
        return posList;
    }
}

