/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class PortalFrameTester {
    protected Predicate<BlockState> VALID_FRAME = null;
    protected int foundPortalBlocks;
    public BlockPos lowerCorner;
    protected World world;

    public abstract PortalFrameTester init(World var1, BlockPos var2, Direction.Axis var3, Predicate<BlockState> var4);

    public abstract Optional<PortalFrameTester> getNewPortal(World var1, BlockPos var2, Direction.Axis var3, Predicate<BlockState> var4);

    public abstract Optional<PortalFrameTester> getOrEmpty(World var1, BlockPos var2, Predicate<PortalFrameTester> var3, Direction.Axis var4, Predicate<BlockState> var5);

    public abstract boolean isAlreadyLitPortalFrame();

    public abstract boolean isValidFrame();

    public abstract void lightPortal(Block var1);

    public abstract void createPortal(World var1, BlockPos var2, BlockState var3, Direction.Axis var4);

    public abstract boolean isRequestedSize(int var1, int var2);

    public abstract Direction.Axis getAxis1();

    public abstract Direction.Axis getAxis2();

    public abstract BlockPos doesPortalFitAt(World var1, BlockPos var2, Direction.Axis var3);

    protected BlockPos getLowerCorner(BlockPos blockPos, Direction.Axis axis1, Direction.Axis axis2) {
        if (!PortalFrameTester.validStateInsidePortal(this.world.func_180495_p(blockPos), this.VALID_FRAME)) {
            return null;
        }
        int offsetX = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.func_180495_p(blockPos.func_241872_a(axis1, -offsetX)), this.VALID_FRAME)) {
            if (++offsetX <= 20) continue;
            return null;
        }
        blockPos = blockPos.func_241872_a(axis1, -(offsetX - 1));
        int offsetY = 1;
        while (blockPos.func_177956_o() - offsetY > 0 && PortalFrameTester.validStateInsidePortal(this.world.func_180495_p(blockPos.func_241872_a(axis2, -offsetY)), this.VALID_FRAME)) {
            if (++offsetY <= 20) continue;
            return null;
        }
        return blockPos.func_241872_a(axis2, -(offsetY - 1));
    }

    protected int getSize(Direction.Axis axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            BlockState blockState = this.world.func_180495_p(this.lowerCorner.func_241872_a(axis, i));
            if (PortalFrameTester.validStateInsidePortal(blockState, this.VALID_FRAME)) continue;
            if (!this.VALID_FRAME.test(blockState)) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    protected boolean checkForValidFrame(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        int i;
        BlockPos.Mutable checkPos = this.lowerCorner.func_239590_i_();
        for (i = 0; i < size1; ++i) {
            if (!this.VALID_FRAME.test(this.world.func_180495_p(checkPos.func_241872_a(axis2, -1))) || !this.VALID_FRAME.test(this.world.func_180495_p(checkPos.func_241872_a(axis2, size2)))) {
                return false;
            }
            checkPos = checkPos.func_241872_a(axis1, 1);
        }
        checkPos = this.lowerCorner.func_239590_i_();
        for (i = 0; i < size2; ++i) {
            if (!this.VALID_FRAME.test(this.world.func_180495_p(checkPos.func_241872_a(axis1, -1))) || !this.VALID_FRAME.test(this.world.func_180495_p(checkPos.func_241872_a(axis1, size1)))) {
                return false;
            }
            checkPos = checkPos.func_241872_a(axis2, 1);
        }
        return true;
    }

    protected void countExistingPortalBlocks(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                if (this.world.func_180495_p(this.lowerCorner.func_241872_a(axis1, i).func_241872_a(axis2, j)).func_177230_c() != BlockRegistry.PORTAL_BLOCK) continue;
                ++this.foundPortalBlocks;
            }
        }
    }

    public static boolean validStateInsidePortal(BlockState blockState, Predicate<BlockState> foundations) {
        return blockState.func_196958_f() || blockState.func_185904_a().func_76222_j() || blockState.func_177230_c() instanceof PortalBlock;
    }
}

