/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarCarbuncle;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class FamiliarCarbyRenderer
extends GeoEntityRenderer<FamiliarCarbuncle> {
    private static final ResourceLocation ORANGE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_purple.png");
    private static final ResourceLocation GREEN = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_green.png");
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");

    public FamiliarCarbyRenderer(EntityRendererManager manager) {
        super(manager, (AnimatedGeoModel)new FamiliarCarbyModel());
    }

    protected void applyRotations(FamiliarCarbuncle entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public void render(FamiliarCarbuncle entity, float entityYaw, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int p_225623_6_) {
        super.render((LivingEntity)entity, entityYaw, p_225623_3_, matrixStack, iRenderTypeBuffer, p_225623_6_);
    }

    public ResourceLocation getColor(FamiliarCarbuncle e) {
        String color = ((String)e.func_184212_Q().func_187225_a(EntityCarbuncle.COLOR)).toLowerCase();
        if (color.isEmpty()) {
            return ORANGE;
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    public ResourceLocation getTextureLocation(FamiliarCarbuncle entity) {
        return WILD_TEXTURE;
    }

    public RenderType getRenderType(FamiliarCarbuncle animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228640_c_((ResourceLocation)textureLocation);
    }

    public static class FamiliarCarbyModel
    extends AnimatedGeoModel<FamiliarCarbuncle> {
        private final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
        private final ResourceLocation TAMED_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");

        public void setLivingAnimations(FamiliarCarbuncle entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
            super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
            IBone head = this.getAnimationProcessor().getBone("head");
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }

        public ResourceLocation getModelLocation(FamiliarCarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "geo/carbuncle.geo.json");
        }

        public ResourceLocation getTextureLocation(FamiliarCarbuncle carbuncle) {
            return this.WILD_TEXTURE;
        }

        public ResourceLocation getAnimationFileLocation(FamiliarCarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "animations/carbuncle_animations.json");
        }
    }
}

