/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.mana.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class VitalicSourcelinkTile
extends SourcelinkTile {
    private static final String TAG_POISONED = "quark:poison_potato_applied";

    public VitalicSourcelinkTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public VitalicSourcelinkTile() {
        super(BlockRegistry.VITALIC_TILE);
    }

    @Override
    public int getMaxMana() {
        return 2500;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 60L == 0L) {
            for (AnimalEntity entity : this.field_145850_b.func_225317_b(AnimalEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(6.0))) {
                if (!entity.func_70631_g_() || entity.func_70874_b() >= 0) continue;
                if (ModList.get().isLoaded("quark") && entity.getPersistentData().func_74764_b(TAG_POISONED)) {
                    return;
                }
                entity.func_70873_a(Math.min(0, entity.func_70874_b() + 500));
                this.addMana(10);
                ParticleUtil.spawnFollowProjectile(this.field_145850_b, entity.func_233580_cy_(), this.field_174879_c);
            }
        }
    }

    @SubscribeEvent
    public static void babySpawnEvent(BabyEntitySpawnEvent e) {
        int mana = 600;
        SourcelinkEventQueue.addManaEvent(e.getParentA().field_70170_p, VitalicSourcelinkTile.class, mana, (Event)e, e.getParentA().func_233580_cy_());
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent e) {
        if (e.getEntityLiving().field_70170_p.field_72995_K || e.getEntity() instanceof IDispellable || e.getEntity() instanceof ISummon) {
            return;
        }
        int mana = 200;
        SourcelinkEventQueue.addManaEvent(e.getEntityLiving().field_70170_p, VitalicSourcelinkTile.class, mana, (Event)e, e.getEntityLiving().func_233580_cy_());
    }

    @Override
    public boolean usesEventQueue() {
        return true;
    }
}

