/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityOrbitProjectile
extends EntityProjectileSpell {
    public Entity wardedEntity;
    int ticksLeft;
    private static final DataParameter<Integer> OWNER_UUID = EntityDataManager.func_187226_a(EntityOrbitProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> OFFSET = EntityDataManager.func_187226_a(EntityOrbitProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ACCELERATES = EntityDataManager.func_187226_a(EntityOrbitProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> AOE = EntityDataManager.func_187226_a(EntityOrbitProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> TOTAL = EntityDataManager.func_187226_a(EntityOrbitProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int extendTimes;

    public EntityOrbitProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityOrbitProjectile(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public EntityOrbitProjectile(World world, SpellResolver resolver) {
        super(world, resolver);
    }

    public EntityOrbitProjectile(EntityType<EntityOrbitProjectile> entityWardProjectileEntityType, World world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.field_70180_af.func_187227_b(OFFSET, (Object)offset);
    }

    public int getOffset() {
        int val = 15;
        return (Integer)this.field_70180_af.func_187225_a(OFFSET) * val;
    }

    public void setTotal(int total) {
        this.field_70180_af.func_187227_b(TOTAL, (Object)total);
    }

    public int getTotal() {
        return (Integer)this.field_70180_af.func_187225_a(TOTAL) > 0 ? (Integer)this.field_70180_af.func_187225_a(TOTAL) : 1;
    }

    public void setAccelerates(int accelerates) {
        this.field_70180_af.func_187227_b(ACCELERATES, (Object)accelerates);
    }

    public int getAccelerates() {
        return (Integer)this.field_70180_af.func_187225_a(ACCELERATES);
    }

    public void setAoe(int aoe) {
        this.field_70180_af.func_187227_b(AOE, (Object)aoe);
    }

    public int getAoe() {
        return (Integer)this.field_70180_af.func_187225_a(AOE);
    }

    @Override
    public void func_70071_h_() {
        EntityRayTraceResult entityraytraceresult;
        ++this.age;
        if (!this.field_70170_p.field_72995_K && this.age > 1200 + 600 * this.extendTimes) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.spellResolver == null) {
            this.func_70106_y();
        }
        Entity owner = this.field_70170_p.func_73045_a(this.getOwnerID());
        if (!this.field_70170_p.field_72995_K && owner == null) {
            this.func_70106_y();
            return;
        }
        if (owner == null) {
            return;
        }
        double rotateSpeed = 10.0 - (double)this.getAccelerates();
        double radiusMultiplier = 1.5 + 0.5 * (double)this.getAoe();
        this.func_70107_b(owner.func_226277_ct_() - radiusMultiplier * Math.sin((double)this.field_70173_aa / rotateSpeed + (double)this.getOffset()), owner.func_226278_cu_() + 1.0, owner.func_226281_cx_() - radiusMultiplier * Math.cos((double)this.field_70173_aa / rotateSpeed + (double)this.getOffset()));
        Vector3d vector3d2 = this.func_213303_ch();
        int nextTick = this.field_70173_aa + 3;
        Vector3d vector3d3 = new Vector3d(owner.func_226277_ct_() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), owner.func_226278_cu_() + 1.0, owner.func_226281_cx_() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = this.func_213866_a(vector3d2, vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.func_234616_v_();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a((RayTraceResult)raytraceresult);
            this.field_70160_al = true;
        }
        if (this.field_70170_p.field_72995_K && this.age > 2) {
            double deltaX = this.func_226277_ct_() - this.field_70142_S;
            double deltaY = this.func_226278_cu_() - this.field_70137_T;
            double deltaZ = this.func_226281_cx_() - this.field_70136_U;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            for (double j = 0.0; j < dist; j += 1.0) {
                double coeff = j / dist;
                this.field_70170_p.func_195594_a(GlowParticleData.createData(this.getParticleColor()), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
            }
        }
    }

    @Override
    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K || result == null) {
            return;
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            if (((EntityRayTraceResult)result).func_216348_a().equals((Object)this.func_234616_v_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_234616_v_(), result);
                Networking.sendToNearby(this.field_70170_p, new BlockPos(result.func_216347_e()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval();
            }
        } else if (this.numSensitive > 0 && result instanceof BlockRayTraceResult && !this.field_70128_L) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_234616_v_(), (RayTraceResult)blockraytraceresult);
            }
            Networking.sendToNearby(this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()).func_177977_b(), this.getParticleColorWrapper(), new int[0]));
            this.attemptRemoval();
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)0);
        this.field_70180_af.func_187214_a(OFFSET, (Object)0);
        this.field_70180_af.func_187214_a(ACCELERATES, (Object)0);
        this.field_70180_af.func_187214_a(AOE, (Object)0);
        this.field_70180_af.func_187214_a(TOTAL, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("left", this.ticksLeft);
        tag.func_74768_a("offset", this.getOffset());
        tag.func_74768_a("aoe", this.getAoe());
        tag.func_74768_a("accelerate", this.getAccelerates());
        tag.func_74768_a("total", this.getTotal());
        tag.func_74768_a("ownerID", this.getOwnerID());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.ticksLeft = tag.func_74762_e("left");
        this.setOffset(tag.func_74762_e("offset"));
        this.setAoe(tag.func_74762_e("aoe"));
        this.setAccelerates(tag.func_74762_e("accelerate"));
        this.setOwnerID(tag.func_74762_e("ownerID"));
        this.setTotal(tag.func_74762_e("total"));
    }

    @Override
    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_WARD;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityOrbitProjectile(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType<? extends EntityProjectileSpell>)ModEntities.ENTITY_WARD, world);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    public int getOwnerID() {
        return (Integer)this.func_184212_Q().func_187225_a(OWNER_UUID);
    }

    public void setOwnerID(int uuid) {
        this.func_184212_Q().func_187227_b(OWNER_UUID, (Object)uuid);
    }
}

