/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class LightningEntity
extends LightningBoltEntity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly;
    List<Integer> hitEntities = new ArrayList<Integer>();
    @Nullable
    private ServerPlayerEntity caster;
    public float amps;
    public int extendTimes;
    public float ampScalar;
    public float wetBonus;

    public LightningEntity(EntityType<? extends LightningBoltEntity> p_i231491_1_, World world) {
        super(p_i231491_1_, world);
        this.field_70158_ak = true;
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
    }

    public void func_233623_a_(boolean effectOnly) {
        this.effectOnly = effectOnly;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_204809_d(@Nullable ServerPlayerEntity casterIn) {
        this.caster = casterIn;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        if (this.lightningState == 2) {
            Difficulty difficulty = this.field_70170_p.func_175659_aa();
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 1.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (!(this.field_70170_p instanceof ServerWorld)) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly) {
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 3.0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - 3.0, this.func_226277_ct_() + 3.0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)this)) continue;
                    float origDamage = this.getDamage();
                    this.setDamage(this.getDamage(entity));
                    EntityStruckByLightningEvent event = new EntityStruckByLightningEvent(entity, (LightningBoltEntity)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) continue;
                    entity.func_241841_a((ServerWorld)this.field_70170_p, (LightningBoltEntity)this);
                    this.setDamage(origDamage);
                    if (!this.field_70170_p.field_72995_K && !this.hitEntities.contains(entity.func_145782_y()) && entity instanceof LivingEntity) {
                        EffectInstance effectInstance = ((LivingEntity)entity).func_70660_b((Effect)ModPotions.SHOCKED_EFFECT);
                        int amp = effectInstance != null ? effectInstance.func_76458_c() : -1;
                        ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)ModPotions.SHOCKED_EFFECT, 200 + 200 * this.extendTimes, Math.min(2, amp + 1)));
                    }
                    if (this.field_70170_p.field_72995_K || this.hitEntities.contains(entity.func_145782_y())) continue;
                    this.hitEntities.add(entity.func_145782_y());
                }
                if (this.caster != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.caster, (Collection)list);
                }
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (!this.effectOnly && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            BlockPos blockpos = this.func_233580_cy_();
            BlockState blockstate = AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockpos);
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                blockstate = AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockpos1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    public float getDamage(Entity entity) {
        float baseDamage = this.getDamage() + this.ampScalar * this.amps + (entity.func_70026_G() ? this.wetBonus : 0.0f);
        int multiplier = 1;
        for (ItemStack i : entity.func_184193_aE()) {
            IEnergyStorage energyStorage = (IEnergyStorage)i.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            if (energyStorage == null) continue;
            ++multiplier;
        }
        if (entity instanceof LivingEntity) {
            IEnergyStorage energyStorage = (IEnergyStorage)((LivingEntity)entity).func_184614_ca().getCapability(CapabilityEnergy.ENERGY).orElse(null);
            if (energyStorage != null) {
                ++multiplier;
            }
            if ((energyStorage = (IEnergyStorage)((LivingEntity)entity).func_184592_cb().getCapability(CapabilityEnergy.ENERGY).orElse(null)) != null) {
                ++multiplier;
            }
        }
        return baseDamage * (float)multiplier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * LightningEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.LIGHTNING_ENTITY;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LightningEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntities.LIGHTNING_ENTITY, world);
    }
}

