/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StoreItemGoal
extends ExtendedRangeGoal {
    private final EntityCarbuncle entityCarbuncle;
    BlockPos storePos;
    boolean unreachable;

    public StoreItemGoal(EntityCarbuncle entityCarbuncle) {
        super(25);
        this.entityCarbuncle = entityCarbuncle;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.storePos = null;
        this.unreachable = false;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.storePos = this.entityCarbuncle.getValidStorePos(this.entityCarbuncle.getHeldStack());
        if (this.storePos != null && !this.entityCarbuncle.getHeldStack().func_190926_b()) {
            this.entityCarbuncle.getNavigation().tryMoveToBlockPos(this.storePos, 1.3);
            this.startDistance = BlockUtil.distanceFrom(this.entityCarbuncle.field_233557_ao_, this.storePos);
        }
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.ticksRunning % 100 == 0 && this.entityCarbuncle.isValidStorePos(this.storePos, this.entityCarbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID) {
            this.storePos = null;
            return;
        }
        if (!this.entityCarbuncle.getHeldStack().func_190926_b() && this.storePos != null && BlockUtil.distanceFrom(this.entityCarbuncle.func_213303_ch(), this.storePos) <= 2.0 + this.extendedRange) {
            this.entityCarbuncle.getNavigation().func_75499_g();
            World world = this.entityCarbuncle.field_70170_p;
            TileEntity tileEntity = world.func_175625_s(this.storePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                ItemStack oldStack = new ItemStack((IItemProvider)this.entityCarbuncle.getHeldStack().func_77973_b(), this.entityCarbuncle.getHeldStack().func_190916_E());
                ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.entityCarbuncle.getHeldStack(), (boolean)false);
                if (left.equals(oldStack)) {
                    return;
                }
                if (world instanceof ServerWorld) {
                    try {
                        OpenChestEvent event = new OpenChestEvent(FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)), this.storePos, 20);
                        event.open();
                        EventQueue.getServerInstance().addEvent(event);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.entityCarbuncle.setHeldStack(left);
                this.entityCarbuncle.setBackOff(5 + this.entityCarbuncle.field_70170_p.field_73012_v.nextInt(20));
                return;
            }
        }
        if (this.storePos != null && !this.entityCarbuncle.getHeldStack().func_190926_b()) {
            this.setPath(this.storePos.func_177958_n(), this.storePos.func_177956_o(), this.storePos.func_177952_p(), 1.3);
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.entityCarbuncle.getNavigation().tryMoveToBlockPos(new BlockPos(x, y, z), 1.3);
        if (this.entityCarbuncle.getNavigation().func_75505_d() != null && !this.entityCarbuncle.getNavigation().func_75505_d().func_224771_h()) {
            this.unreachable = true;
        }
    }

    public boolean func_75253_b() {
        return !this.unreachable && this.entityCarbuncle.isTamed() && this.entityCarbuncle.getHeldStack() != null && !this.entityCarbuncle.getHeldStack().func_190926_b() && this.entityCarbuncle.getBackOff() == 0 && this.storePos != null;
    }

    @Override
    public boolean func_75250_a() {
        return this.entityCarbuncle.isTamed() && this.entityCarbuncle.getHeldStack() != null && !this.entityCarbuncle.getHeldStack().func_190926_b() && this.entityCarbuncle.getBackOff() == 0;
    }
}

