/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wixie;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FindNextItemGoal
extends ExtendedRangeGoal {
    EntityWixie wixie;
    BlockPos movePos;
    ItemStack getStack;
    boolean found;

    public FindNextItemGoal(EntityWixie wixie) {
        super(10);
        this.wixie = wixie;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        World world = this.wixie.func_130014_f_();
        WixieCauldronTile tile = (WixieCauldronTile)world.func_175625_s(this.wixie.cauldronPos);
        if (tile == null || tile.inventories == null) {
            this.found = true;
            return;
        }
        this.getStack = tile.craftManager.getNextItem();
        if (this.getStack.func_190926_b()) {
            this.found = true;
            return;
        }
        HashSet<Item> itemSet = new HashSet<Item>();
        itemSet.add(this.getStack.func_77973_b());
        for (BlockPos b : tile.inventories) {
            IInventory i;
            if (!(world.func_175625_s(b) instanceof IInventory) || !(i = (IInventory)world.func_175625_s(b)).func_213902_a(itemSet)) continue;
            this.movePos = b;
            this.startDistance = BlockUtil.distanceFrom(this.wixie.field_233557_ao_, this.movePos);
            break;
        }
        this.found = false;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }

    @Override
    public boolean func_75250_a() {
        if (this.wixie.cauldronPos == null) {
            return false;
        }
        TileEntity tileEntity = this.wixie.field_70170_p.func_175625_s(this.wixie.cauldronPos);
        return this.wixie.inventoryBackoff == 0 && tileEntity instanceof WixieCauldronTile && ((WixieCauldronTile)tileEntity).hasMana && !((WixieCauldronTile)tileEntity).isCraftingDone() && !((WixieCauldronTile)tileEntity).isOff && !((WixieCauldronTile)tileEntity).craftManager.getNextItem().func_190926_b();
    }

    public boolean func_75253_b() {
        return !this.found && this.movePos != null;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (!this.found && this.movePos != null && BlockUtil.distanceFrom(this.wixie.func_213303_ch(), this.movePos.func_177984_a()) < 2.0 + this.extendedRange) {
            WixieCauldronTile tile = (WixieCauldronTile)this.wixie.func_130014_f_().func_175625_s(this.wixie.cauldronPos);
            World world = this.wixie.func_130014_f_();
            if (tile == null) {
                this.found = true;
                return;
            }
            for (BlockPos b : tile.inventories) {
                if (!(world.func_175625_s(b) instanceof IInventory)) continue;
                IInventory i = (IInventory)world.func_175625_s(b);
                for (int j = 0; j < i.func_70302_i_(); ++j) {
                    if (i.func_70301_a(j).func_77973_b() != this.getStack.func_77973_b()) continue;
                    this.found = true;
                    ItemStack stackToGive = i.func_70301_a(j).func_77946_l();
                    tile.spawnFlyingItem(b, stackToGive);
                    stackToGive.func_190920_e(1);
                    tile.giveItem(stackToGive);
                    i.func_70301_a(j).func_190918_g(1);
                    Networking.sendToNearby(world, (Entity)this.wixie, (Object)new PacketAnimEntity(this.wixie.func_145782_y(), EntityWixie.Animations.SUMMON_ITEM.ordinal()));
                    this.wixie.inventoryBackoff = 60;
                    break;
                }
                if (!this.found) continue;
                break;
            }
        }
        if (this.movePos != null && !this.found) {
            this.setPath(this.movePos.func_177958_n(), this.movePos.func_177956_o() + 1, this.movePos.func_177952_p(), 1.2);
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.wixie.func_70661_as().func_75484_a(this.wixie.func_70661_as().func_225466_a(x + 0.5, y + 0.5, z + 0.5, 0), speedIn);
    }
}

