/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.curios;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.spell.method.MethodOrbit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class SummoningFocus
extends ModItem
implements ISpellModifierItem {
    public static List<AbstractCastMethod> sympatheticMethods = new ArrayList<AbstractCastMethod>();

    public SummoningFocus(Item.Properties properties) {
        super(properties);
    }

    public SummoningFocus(Item.Properties properties, String registryName) {
        super(properties, registryName);
    }

    public SummoningFocus(String registryName) {
        super(registryName);
    }

    @Override
    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        builder.addDamageModifier(1.0);
        return builder;
    }

    public SpellStats.Builder getSimpleStats(SpellStats.Builder builder) {
        builder.addDamageModifier(1.0);
        return builder;
    }

    public static boolean containsThis(World world, Entity entity) {
        IItemHandlerModifiable items;
        if (!world.field_72995_K && entity instanceof PlayerEntity && (items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)entity).orElse(null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof SummoningFocus)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void summonedEvent(SummonEvent event) {
        if (!event.world.field_72995_K && SummoningFocus.containsThis(event.world, event.summon.getOwner((ServerWorld)event.world))) {
            event.summon.setTicksLeft(event.summon.getTicksLeft() * 2);
            if (event.summon.getLivingEntity() != null) {
                event.summon.getLivingEntity().func_195064_c(new EffectInstance(Effects.field_76420_g, 500, 2));
                event.summon.getLivingEntity().func_195064_c(new EffectInstance(Effects.field_76424_c, 500, 1));
            }
        }
    }

    @SubscribeEvent
    public static void castSpell(SpellCastEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity && SummoningFocus.containsThis(event.getWorld(), (Entity)event.getEntityLiving()) && event.spell.getCastMethod() != null && sympatheticMethods.contains(event.spell.getCastMethod())) {
            for (LivingEntity i : event.getWorld().func_225316_b(LivingEntity.class, new AxisAlignedBB(event.getEntityLiving().func_233580_cy_()).func_186662_g(30.0), l -> l instanceof ISummon)) {
                if (!event.getEntityLiving().equals((Object)((ISummon)i).getOwner((ServerWorld)event.getWorld()))) continue;
                EntitySpellResolver spellResolver = new EntitySpellResolver(new SpellContext(event.spell, i).withColors(event.context.colors));
                spellResolver.onCast(ItemStack.field_190927_a, i, i.field_70170_p);
            }
        }
    }

    @SubscribeEvent
    public static void summonDeathEvent(SummonEvent.Death event) {
        DamageSource source;
        if (!event.world.field_72995_K && SummoningFocus.containsThis(event.world, event.summon.getOwner((ServerWorld)event.world)) && (source = event.source) != null && source.func_76346_g() != null) {
            source.func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)source.func_76346_g()).func_76348_h(), 5.0f);
        }
    }

    static {
        sympatheticMethods.add(MethodSelf.INSTANCE);
        sympatheticMethods.add(MethodOrbit.INSTANCE);
    }
}

