/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectBlink
extends AbstractEffect {
    public static EffectBlink INSTANCE = new EffectBlink();

    private EffectBlink() {
        super("blink", "Blink");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos;
        ItemStack scroll;
        Vector3d vec = this.safelyGetHitPos((RayTraceResult)rayTraceResult);
        double distance = (double)((Integer)this.GENERIC_INT.get()).intValue() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        if (spellContext.castingTile instanceof IInventoryResponder && !(scroll = ((IInventoryResponder)spellContext.castingTile).getItem(new ItemStack((IItemProvider)ItemsRegistry.warpScroll))).func_190926_b() && (pos = WarpScroll.getPos(scroll)) != null) {
            EffectBlink.warpEntity(rayTraceResult.func_216348_a(), pos);
            return;
        }
        if (rayTraceResult.func_216348_a().equals((Object)shooter)) {
            EffectBlink.blinkForward(world, shooter, distance);
            return;
        }
        if (this.isRealPlayer(shooter) && spellContext.castingTile == null && shooter != null) {
            if (shooter.func_184592_cb().func_77973_b() instanceof WarpScroll) {
                BlockPos warpPos = WarpScroll.getPos(shooter.func_184592_cb());
                if (warpPos != null && !warpPos.equals((Object)BlockPos.field_177992_a)) {
                    EffectBlink.warpEntity(rayTraceResult.func_216348_a(), warpPos);
                }
            } else {
                shooter.func_70634_a(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
            }
        } else if (spellContext.getType() == SpellContext.CasterType.RUNE && rayTraceResult.func_216348_a() instanceof LivingEntity) {
            EffectBlink.blinkForward(world, (LivingEntity)rayTraceResult.func_216348_a(), distance);
        }
    }

    public static void warpEntity(Entity entity, BlockPos warpPos) {
        if (entity == null) {
            return;
        }
        World world = entity.field_70170_p;
        ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_(), 4, (world.field_73012_v.nextDouble() - 0.5) * 2.0, -world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
        entity.func_70634_a((double)warpPos.func_177958_n() + 0.5, (double)warpPos.func_177956_o(), (double)warpPos.func_177952_p() + 0.5);
        Networking.sendToNearby(world, entity, (Object)new PacketWarpPosition(entity.func_145782_y(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70125_A, entity.field_70177_z));
        entity.field_70170_p.func_184133_a(null, warpPos, SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)warpPos.func_177958_n() + 0.5, (double)warpPos.func_177956_o() + 1.0, (double)warpPos.func_177952_p() + 0.5, 4, (world.field_73012_v.nextDouble() - 0.5) * 2.0, -world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        Vector3d vec = rayTraceResult.func_216347_e();
        if (this.isRealPlayer(shooter) && EffectBlink.isValidTeleport(world, rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b()))) {
            EffectBlink.warpEntity((Entity)shooter, new BlockPos(vec));
        }
    }

    public static void blinkForward(World world, LivingEntity shooter, double distance) {
        Vector3d lookVec = new Vector3d(shooter.func_70040_Z().func_82615_a(), 0.0, shooter.func_70040_Z().func_82616_c());
        Vector3d vec = shooter.func_213303_ch().func_178787_e(lookVec.func_186678_a(distance));
        BlockPos pos = new BlockPos(vec);
        if (!EffectBlink.isValidTeleport(world, pos)) {
            BlockPos blockPos = pos = EffectBlink.getForward(world, pos, shooter, distance) == null ? EffectBlink.getForward(world, pos.func_177981_b(2), shooter, distance) : EffectBlink.getForward(world, pos, shooter, distance);
        }
        if (pos == null) {
            return;
        }
        EffectBlink.warpEntity((Entity)shooter, pos);
    }

    public static BlockPos getForward(World world, BlockPos pos, LivingEntity shooter, double distance) {
        Vector3d lookVec = new Vector3d(shooter.func_70040_Z().func_82615_a(), 0.0, shooter.func_70040_Z().func_82616_c());
        Vector3d oldVec = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_178787_e(lookVec.func_186678_a(distance));
        for (double i = distance; i >= 0.0; i -= 1.0) {
            Vector3d vec = oldVec.func_178787_e(lookVec.func_186678_a(i));
            BlockPos sendPos = new BlockPos(vec);
            if (i <= 0.0) {
                return null;
            }
            if (!EffectBlink.isValidTeleport(world, sendPos)) continue;
            return sendPos;
        }
        return null;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 8, "Base teleport distance", "distance");
        this.addAmpConfig(builder, 3.0);
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    public static boolean isValidTeleport(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177984_a()).func_200132_m() && !world.func_180495_p(pos.func_177981_b(2)).func_200132_m();
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151079_bi;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Teleports the caster to a location. If an entity is hit and the caster is holding a Warp Scroll in the offhand, the entity will be warped to the location on the Warp Scroll. When used on Self, the caster blinks forward. Spell Turrets and Runes can warp entities using Warp Scrolls from adjacent inventories without consuming the scroll.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

