/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectWindshear
extends AbstractEffect {
    public static EffectWindshear INSTANCE = new EffectWindshear();

    private EffectWindshear() {
        super("wind_shear", "Wind Shear");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        if (!rayTraceResult.func_216348_a().func_233570_aj_()) {
            int numBlocks;
            BlockPos pos = rayTraceResult.func_216348_a().func_233580_cy_();
            for (numBlocks = 0; !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c() && numBlocks <= 10; ++numBlocks) {
                pos = pos.func_177977_b();
            }
            this.dealDamage(world, shooter, (float)((Double)this.DAMAGE.get() + (double)numBlocks), spellStats, rayTraceResult.func_216348_a(), DamageSource.field_76379_h);
            Vector3d vec = rayTraceResult.func_216348_a().field_233557_ao_;
            for (int i = 0; i < 10; ++i) {
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197603_N, vec.field_72450_a + ParticleUtil.inRange(-0.2, 0.2), vec.field_72448_b + 0.5 + ParticleUtil.inRange(-0.2, 0.2), vec.field_72449_c + ParticleUtil.inRange(-0.2, 0.2), 30, ParticleUtil.inRange(-0.2, 0.2), ParticleUtil.inRange(-0.2, 0.2), ParticleUtil.inRange(-0.2, 0.2), 0.3);
            }
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 5.0);
        this.addAmpConfig(builder, 2.5);
        this.addGenericDouble(builder, 0.75, "Damage per block in the air", "airDamage");
    }

    @Override
    public String getBookDescription() {
        return "Deals damage to targets in the air, with an increasing amount based on how high the target is off the ground, up to 10 blocks. Targets on the ground take no damage.";
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return ArsNouveauAPI.getInstance().getGlyphItem(EffectKnockback.INSTANCE);
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_AIR);
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentDampen.INSTANCE, AugmentAmplify.INSTANCE);
    }
}

