/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class MagicTrunkPlacer
extends AbstractTrunkPlacer {
    public MagicTrunkPlacer(int baseHeight, int height_rand_a, int height_rand_b) {
        super(baseHeight, height_rand_a, height_rand_b);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TrunkPlacerType.field_236924_e_;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int foliageHeight, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox boundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = pos.func_177977_b();
        MagicTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos);
        MagicTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177974_f());
        MagicTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d());
        MagicTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d().func_177974_f());
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int yOffset = y + foliageHeight - 1;
        int numBranches = 0;
        int lastBranch = 0;
        boolean northB = (double)rand.nextFloat() >= 0.5;
        boolean southB = (double)rand.nextFloat() >= 0.5;
        boolean eastB = (double)rand.nextFloat() >= 0.5;
        boolean westB = (double)rand.nextFloat() >= 0.5;
        for (int i = 0; i < foliageHeight; ++i) {
            int j2 = y + i;
            BlockPos blockpos1 = new BlockPos(x, j2, z);
            if (TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)blockpos1)) {
                MagicTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos1, posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                MagicTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos1.func_177974_f(), posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                MagicTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos1.func_177968_d(), posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
                MagicTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos1.func_177974_f().func_177968_d(), posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig);
            }
            if (i < 1) {
                this.addRoots(world, rand, pos.func_177976_e().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177968_d().func_177968_d().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177968_d().func_177976_e().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177968_d().func_177968_d().func_177974_f().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177974_f().func_177974_f().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177974_f().func_177974_f().func_177968_d().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177974_f().func_177978_c().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.func_177978_c().func_177981_b(i), posSet, boundingBox, baseTreeFeatureConfig);
            }
            if (i > 1 && i > lastBranch) {
                if (northB) {
                    this.addBranch(world, pos, posSet, boundingBox, i, Direction.NORTH, rand, baseTreeFeatureConfig);
                    lastBranch = i;
                    ++numBranches;
                    northB = false;
                } else if (southB) {
                    this.addBranch(world, pos.func_177972_a(Direction.SOUTH), posSet, boundingBox, i, Direction.SOUTH, rand, baseTreeFeatureConfig);
                    lastBranch = i;
                    ++numBranches;
                    southB = false;
                } else if (eastB) {
                    this.addBranch(world, pos.func_177972_a(Direction.EAST).func_177968_d(), posSet, boundingBox, i, Direction.EAST, rand, baseTreeFeatureConfig);
                    lastBranch = i;
                    ++numBranches;
                    eastB = false;
                } else if (westB) {
                    this.addBranch(world, pos, posSet, boundingBox, i, Direction.WEST, rand, baseTreeFeatureConfig);
                    lastBranch = i;
                    ++numBranches;
                    westB = false;
                } else if (numBranches == 0) {
                    this.addBranch(world, pos, posSet, boundingBox, i, Direction.NORTH, rand, baseTreeFeatureConfig);
                    lastBranch = i;
                    ++numBranches;
                    this.addBranch(world, pos, posSet, boundingBox, i, Direction.SOUTH, rand, baseTreeFeatureConfig);
                    ++numBranches;
                }
            }
            if (i != foliageHeight - 2) continue;
            float leafChance = 0.1f;
            this.addLineLeaves(world, pos.func_177964_d(4).func_177981_b(i), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177964_d(4).func_177981_b(i + 1), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177964_d(3).func_177981_b(i - 1), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177964_d(3).func_177981_b(i), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177964_d(3).func_177981_b(i + 1), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177964_d(2).func_177981_b(i + 1), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177964_d(1).func_177981_b(i + 1), posSet, boundingBox, Direction.NORTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177964_d(2).func_177981_b(i + 2), posSet, boundingBox, Direction.NORTH, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(5).func_177981_b(i), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(5).func_177981_b(i + 1), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(4).func_177981_b(i - 1), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(4).func_177981_b(i), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(4).func_177981_b(i + 1), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(3).func_177981_b(i + 1), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(2).func_177981_b(i + 1), posSet, boundingBox, Direction.EAST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(3).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(2).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(1).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(0).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(-1).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(-2).func_177981_b(i + 2), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177985_f(4).func_177968_d().func_177981_b(i), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177985_f(4).func_177968_d().func_177981_b(i + 1), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177985_f(3).func_177968_d().func_177981_b(i - 1), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177985_f(3).func_177968_d().func_177981_b(i), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177985_f(3).func_177968_d().func_177981_b(i + 1), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177985_f(2).func_177968_d().func_177981_b(i + 1), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177985_f(1).func_177968_d().func_177981_b(i + 1), posSet, boundingBox, Direction.WEST, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177985_f(2).func_177968_d().func_177981_b(i + 2), posSet, boundingBox, Direction.WEST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177970_e(4).func_177974_f().func_177981_b(i), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177970_e(4).func_177974_f().func_177981_b(i + 1), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177970_e(5).func_177974_f().func_177981_b(i), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177970_e(5).func_177974_f().func_177981_b(i + 1), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177970_e(3).func_177974_f().func_177981_b(i + 1), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177970_e(2).func_177974_f().func_177981_b(i + 1), posSet, boundingBox, Direction.SOUTH, 6, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177970_e(3).func_177974_f().func_177981_b(i + 2), posSet, boundingBox, Direction.SOUTH, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(2).func_177981_b(i + 3), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(1).func_177981_b(i + 3), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(0).func_177981_b(i + 3), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(-1).func_177981_b(i + 3), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177965_g(2).func_177981_b(i + 4), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(1).func_177981_b(i + 4), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(0).func_177981_b(i + 4), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance);
            this.addLineLeaves(world, pos.func_177965_g(-1).func_177981_b(i + 4), posSet, boundingBox, Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance);
        }
        list.add(new FoliagePlacer.Foliage(new BlockPos(x, yOffset, z), 0, true));
        return list;
    }

    public void addBranch(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox boundingBox, int height, Direction d, Random random, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        pos = pos.func_177981_b(height);
        this.addLog(world, pos.func_177972_a(d), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLog(world, pos.func_177972_a(d).func_177981_b(1), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLog(world, pos.func_177972_a(d).func_177981_b(2), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLog(world, pos.func_177967_a(d, 2).func_177981_b(2), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLog(world, pos.func_177967_a(d, 3).func_177981_b(2), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLog(world, pos.func_177967_a(d, 3).func_177981_b(1), posSet, boundingBox, random, baseTreeFeatureConfig);
        this.addLineLeaves(world, pos.func_177972_a(d).func_177981_b(1), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
        this.addLineLeaves(world, pos.func_177972_a(d).func_177981_b(2), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
        this.addLineLeaves(world, pos.func_177972_a(d).func_177981_b(3), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
        for (int j = 1; j < 4; ++j) {
            this.addLineLeaves(world, pos.func_177967_a(d, j).func_177981_b(3), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177967_a(d, j).func_177981_b(2), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
            this.addLineLeaves(world, pos.func_177967_a(d, j).func_177981_b(4), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig, 0.1f);
        }
        for (int i = 0; i < 2; ++i) {
            this.addHollowLine(world, pos.func_177967_a(d, 2 + i).func_177981_b(1), posSet, boundingBox, d, 2, random, baseTreeFeatureConfig);
            this.addHollowLine(world, pos.func_177967_a(d, 2 + i).func_177981_b(2), posSet, boundingBox, d, 2, random, baseTreeFeatureConfig);
            this.addHollowLine(world, pos.func_177967_a(d, 2 + i).func_177981_b(1), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig, 0.1f);
            this.addHollowLine(world, pos.func_177967_a(d, 2 + i).func_177981_b(2), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig, 0.1f);
        }
        this.addLineLeaves(world, pos.func_177967_a(d, 4).func_177981_b(1), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
        this.addLineLeaves(world, pos.func_177967_a(d, 4).func_177981_b(2), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig);
        this.addLineLeaves(world, pos.func_177967_a(d, 5).func_177981_b(1), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig, 0.1f);
        this.addLineLeaves(world, pos.func_177967_a(d, 5).func_177981_b(2), posSet, boundingBox, d, 3, random, baseTreeFeatureConfig, 0.1f);
    }

    public boolean addLog(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Random random, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        return this.addBlock(world, pos, posSet, mutableBoundingBox, baseTreeFeatureConfig.field_227368_m_.func_225574_a_(random, pos));
    }

    public boolean addBlock(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, BlockState state) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)state, (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    public void addHollowLine(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        this.addHollowLine(world, pos, posSet, mutableBoundingBox, d, length, rand, baseTreeFeatureConfig, 1.0f);
    }

    public void addHollowLine(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig, float chance) {
        Direction left = d.func_176746_e();
        Direction right = left.func_176734_d();
        if (rand.nextFloat() <= chance && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177967_a(left, length))) {
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos.func_177967_a(left, length), (BlockState)baseTreeFeatureConfig.field_227369_n_.func_225574_a_(rand, pos.func_177967_a(left, length)), (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_177967_a(left, length).func_185334_h());
        }
        if (rand.nextFloat() <= chance && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177967_a(right, length))) {
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos.func_177967_a(right, length), (BlockState)baseTreeFeatureConfig.field_227369_n_.func_225574_a_(rand, pos.func_177967_a(right, length)), (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_177967_a(right, length).func_185334_h());
        }
    }

    public void addLineLeaves(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, posSet, mutableBoundingBox, d, length, rand, baseTreeFeatureConfig, 1.0f);
        } else {
            this.addLineLeavesOdd(world, pos, posSet, mutableBoundingBox, d, length, rand, baseTreeFeatureConfig, 1.0f);
        }
    }

    public void addLineLeaves(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig, float chance) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, posSet, mutableBoundingBox, d, length, rand, baseTreeFeatureConfig, chance);
        } else {
            this.addLineLeavesOdd(world, pos, posSet, mutableBoundingBox, d, length, rand, baseTreeFeatureConfig, chance);
        }
    }

    public void addLineLeavesEven(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig, float chance) {
        Direction left = d.func_176746_e();
        Direction right = left.func_176734_d();
        for (int i = 0; i < length; ++i) {
            if (!(rand.nextFloat() <= chance) || !TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177967_a(left, i - length / 3))) continue;
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos.func_177967_a(left, i - length / 3), (BlockState)baseTreeFeatureConfig.field_227369_n_.func_225574_a_(rand, pos.func_177967_a(left, i - length / 3)), (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_177967_a(left, i - length / 3).func_185334_h());
        }
    }

    public void addLineLeavesOdd(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, Direction d, int length, Random rand, BaseTreeFeatureConfig baseTreeFeatureConfig, float chance) {
        Direction left = d.func_176746_e();
        Direction right = left.func_176734_d();
        length += 2;
        for (int i = 0; i < (length - 1) / 2; ++i) {
            if (rand.nextFloat() <= chance && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177967_a(left, i))) {
                MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos.func_177967_a(left, i), (BlockState)baseTreeFeatureConfig.field_227369_n_.func_225574_a_(rand, pos.func_177967_a(left, i)), (MutableBoundingBox)mutableBoundingBox);
                posSet.add(pos.func_177967_a(left, i).func_185334_h());
            }
            if (!(rand.nextFloat() <= chance) || !TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177967_a(right, i))) continue;
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos.func_177967_a(right, i), (BlockState)baseTreeFeatureConfig.field_227369_n_.func_225574_a_(rand, pos.func_177967_a(right, i)), (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_177967_a(right, i).func_185334_h());
        }
    }

    public boolean addRoots(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        BlockState state = baseTreeFeatureConfig.field_227368_m_.func_225574_a_(rand, pos);
        if (rand.nextDouble() < 0.75 && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            MagicTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)state, (MutableBoundingBox)mutableBoundingBox);
            posSet.add(pos.func_185334_h());
            return true;
        }
        return false;
    }
}

