/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.handler;

import com.inventorypets.InventoryPets;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerDoubleChest
extends ItemStackHandler {
    public static final int MIN_SLOTS = 1;
    public static final int MAX_SLOTS = 54;
    private boolean isDirty = true;

    public ItemStackHandlerDoubleChest(int numberOfSlots) {
        super(MathHelper.func_76125_a((int)numberOfSlots, (int)1, (int)54));
        if (numberOfSlots < 1 || numberOfSlots > 54) {
            throw new IllegalArgumentException("Invalid number of slots:" + numberOfSlots);
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot < 0 || slot >= 54) {
            throw new IllegalArgumentException("Invalid slot number:" + slot);
        }
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() != InventoryPets.FEED_BAG.get() && stack.func_77973_b() != InventoryPets.PET_CHEST.get() && stack.func_77973_b() != InventoryPets.PET_DOUBLE_CHEST.get();
    }

    public int getNumberOfEmptySlots() {
        int NUMBER_OF_SLOTS = this.getSlots();
        int emptySlotCount = 0;
        for (int i = 0; i < NUMBER_OF_SLOTS; ++i) {
            if (this.getStackInSlot(i) != ItemStack.field_190927_a) continue;
            ++emptySlotCount;
        }
        return emptySlotCount;
    }

    public boolean isDirty() {
        boolean currentState = this.isDirty;
        this.isDirty = false;
        return currentState;
    }

    protected void onContentsChanged(int slot) {
        this.isDirty = true;
    }
}

