/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.init;

import com.inventorypets.InventoryPets;
import com.inventorypets.container.ContainerChest;
import com.inventorypets.container.ContainerDoubleChest;
import com.inventorypets.container.ContainerFeedBag;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventorypets", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"inventorypets Mod Event Subscriber");
    private static final String[] BLOCKITEMFILTER = new String[]{"cloud_block", "cloud_spawn", "nether_spawn", "sand_block", "sand_spawn", "space_spawn", "stone_block", "stone_spawn"};
    public static ContainerType<ContainerFeedBag> containerTypeFeedBag;
    public static ContainerType<ContainerChest> containerTypeChest;
    public static ContainerType<ContainerDoubleChest> containerTypeDoubleChest;

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        InventoryPets.BLOCKS.getEntries().stream().filter(x -> ModRegistry.checkBlockItemFilter(((Block)x.get()).getRegistryName().func_110623_a())).map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(InventoryPets.MOD_ITEM_GROUP);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        LOGGER.debug("Registered BlockItems!");
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        containerTypeFeedBag = IForgeContainerType.create(ContainerFeedBag::createContainerClientSide);
        containerTypeFeedBag.setRegistryName("container_type_feed_bag");
        event.getRegistry().register(containerTypeFeedBag);
        containerTypeChest = IForgeContainerType.create(ContainerChest::createContainerClientSide);
        containerTypeChest.setRegistryName("container_type_chest");
        event.getRegistry().register(containerTypeChest);
        containerTypeDoubleChest = IForgeContainerType.create(ContainerDoubleChest::createContainerClientSide);
        containerTypeDoubleChest.setRegistryName("container_type_double_chest");
        event.getRegistry().register(containerTypeDoubleChest);
    }

    private static boolean checkBlockItemFilter(String name) {
        return Arrays.stream(BLOCKITEMFILTER).anyMatch(name::equals);
    }
}

