/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.inventorypets.worldgen.NetherDungeonStructure;
import com.inventorypets.worldgen.SeaCaveStructure;
import com.inventorypets.worldgen.SkyDungeonStructure;
import com.inventorypets.worldgen.SpaceDungeonStructure;
import com.inventorypets.worldgen.TreeTopStructure;
import com.inventorypets.worldgen.UndergroundDungeonStructure;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WorldGen {
    static DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"inventorypets");
    static List<Structure<?>> STRUCTURE_LIST = new ArrayList();
    static Map<ResourceLocation, StructureSeparationSettings> STRUCTURE_SETTINGS = new HashMap<ResourceLocation, StructureSeparationSettings>();
    public static IStructurePieceType SKY_DUNGEON_PIECE;
    public static IStructurePieceType SPACE_DUNGEON_PIECE;
    public static IStructurePieceType NETHER_DUNGEON_PIECE;
    public static IStructurePieceType UNDERGROUND_DUNGEON_PIECE;
    public static IStructurePieceType TREE_TOP_PIECE;
    public static IStructurePieceType SEA_CAVE_PIECE;
    public static RegistryObject<Structure<NoFeatureConfig>> SKY_DUNGEON_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> SPACE_DUNGEON_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> NETHER_DUNGEON_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> UNDERGROUND_DUNGEON_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> TREE_TOP_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> SEA_CAVE_STRUCTURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> SKY_DUNGEON_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> SPACE_DUNGEON_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> NETHER_DUNGEON_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> UNDERGROUND_DUNGEON_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> TREE_TOP_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> SEA_CAVE_FEATURE;

    static IStructurePieceType register(IStructurePieceType type, String name) {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("inventorypets", name), (Object)type);
        return type;
    }

    static <C extends IFeatureConfig, S extends Structure<C>> StructureFeature<C, S> register(StructureFeature<C, S> feature, String name) {
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("inventorypets", name), feature);
        return feature;
    }

    static <C extends IFeatureConfig> RegistryObject<Structure<C>> addStructure(String name, Structure<C> structure, GenerationStage.Decoration stage, StructureSeparationSettings settings) {
        Structure.field_236365_a_.put((Object)("inventorypets:" + name), structure);
        Structure.field_236385_u_.put(structure, stage);
        STRUCTURE_LIST.add(structure);
        STRUCTURE_SETTINGS.put(new ResourceLocation("inventorypets", name), settings);
        if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        return STRUCTURES.register(name, () -> structure);
    }

    public static void preInit() {
        STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void init() {
        SKY_DUNGEON_PIECE = WorldGen.register(SkyDungeonStructure.Piece::new, "sky_dungeon");
        SKY_DUNGEON_FEATURE = WorldGen.register(((Structure)SKY_DUNGEON_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "sky_dungeon");
        SPACE_DUNGEON_PIECE = WorldGen.register(SpaceDungeonStructure.Piece::new, "space_dungeon");
        SPACE_DUNGEON_FEATURE = WorldGen.register(((Structure)SPACE_DUNGEON_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "space_dungeon");
        UNDERGROUND_DUNGEON_PIECE = WorldGen.register(UndergroundDungeonStructure.Piece::new, "underground_dungeon");
        UNDERGROUND_DUNGEON_FEATURE = WorldGen.register(((Structure)UNDERGROUND_DUNGEON_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "underground_dungeon");
        TREE_TOP_PIECE = WorldGen.register(TreeTopStructure.Piece::new, "tree_top");
        TREE_TOP_FEATURE = WorldGen.register(((Structure)TREE_TOP_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "tree_top");
        SEA_CAVE_PIECE = WorldGen.register(SeaCaveStructure.Piece::new, "sea_cave");
        SEA_CAVE_FEATURE = WorldGen.register(((Structure)SEA_CAVE_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "sea_cave");
        NETHER_DUNGEON_PIECE = WorldGen.register(NetherDungeonStructure.Piece::new, "nether_dungeon");
        NETHER_DUNGEON_FEATURE = WorldGen.register(((Structure)NETHER_DUNGEON_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "nether_dungeon");
        for (Structure<?> s : STRUCTURE_LIST) {
            ImmutableSet.of((Object)DimensionSettings.field_242734_c, (Object)DimensionSettings.field_242736_e);
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(s, (Object)STRUCTURE_SETTINGS.get(s.getRegistryName())).build();
            DimensionSettings.field_242740_q.func_236108_a_().field_236193_d_.put(s, STRUCTURE_SETTINGS.get(s.getRegistryName()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().func_242516_a(SKY_DUNGEON_FEATURE);
        event.getGeneration().func_242516_a(SPACE_DUNGEON_FEATURE);
        event.getGeneration().func_242516_a(UNDERGROUND_DUNGEON_FEATURE);
        if (event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.SAVANNA || event.getCategory() == Biome.Category.TAIGA || event.getCategory() == Biome.Category.EXTREME_HILLS) {
            event.getGeneration().func_242516_a(TREE_TOP_FEATURE);
        } else if (event.getCategory() == Biome.Category.OCEAN) {
            event.getGeneration().func_242516_a(SEA_CAVE_FEATURE);
        } else if (event.getCategory() == Biome.Category.SWAMP || event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().func_242516_a(NETHER_DUNGEON_FEATURE);
        }
    }

    static {
        SKY_DUNGEON_STRUCTURE = WorldGen.addStructure("sky_dungeon", new SkyDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.RAW_GENERATION, new StructureSeparationSettings(7, 6, 1236));
        SPACE_DUNGEON_STRUCTURE = WorldGen.addStructure("space_dungeon", new SpaceDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.RAW_GENERATION, new StructureSeparationSettings(9, 5, 1337));
        NETHER_DUNGEON_STRUCTURE = WorldGen.addStructure("nether_dungeon", new NetherDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.RAW_GENERATION, new StructureSeparationSettings(7, 5, 1438));
        UNDERGROUND_DUNGEON_STRUCTURE = WorldGen.addStructure("underground_dungeon", new UndergroundDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.RAW_GENERATION, new StructureSeparationSettings(8, 7, 1539));
        TREE_TOP_STRUCTURE = WorldGen.addStructure("tree_top", new TreeTopStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(4, 3, 1640));
        SEA_CAVE_STRUCTURE = WorldGen.addStructure("sea_cave", new SeaCaveStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.RAW_GENERATION, new StructureSeparationSettings(7, 6, 1741));
    }
}

