/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.capability;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.cap.BaublesCapabilities;
import lazy.baubles.api.cap.IBaublesItemHandler;
import lazy.baubles.event.EventHandlerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class BaublesContainer
extends ItemStackHandler
implements IBaublesItemHandler {
    private static final int BAUBLE_SLOTS = 7;
    private final ItemStack[] previous = new ItemStack[7];
    private boolean[] changed = new boolean[7];
    private boolean blockEvents = false;
    private LivingEntity holder;

    public BaublesContainer(LivingEntity player) {
        super(7);
        this.holder = player;
        Arrays.fill(this.previous, ItemStack.field_190927_a);
    }

    public void setSize(int size) {
        if (size != 7) {
            System.out.println("Cannot resize baubles container");
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        LazyOptional opt = stack.getCapability(BaublesCapabilities.ITEM_BAUBLE);
        if (stack.func_190926_b() || !opt.isPresent()) {
            return false;
        }
        IBauble bauble = (IBauble)opt.orElseThrow(NullPointerException::new);
        return bauble.canEquip(this.holder) && bauble.getBaubleType(stack).hasSlot(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || this.isItemValidForSlot(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }

    protected void onContentsChanged(int slot) {
        this.changed[slot] = true;
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            stack.getCapability(BaublesCapabilities.ITEM_BAUBLE).ifPresent(b -> b.onWornTick(this.holder, stack));
        }
        this.sync();
    }

    private void sync() {
        if (!(this.holder instanceof ServerPlayerEntity)) {
            return;
        }
        ArrayList<ServerPlayerEntity> receivers = null;
        for (byte i = 0; i < this.getSlots(); i = (byte)((byte)(i + 1))) {
            ItemStack stack = this.getStackInSlot(i);
            boolean autosync = stack.getCapability(BaublesCapabilities.ITEM_BAUBLE).map(b -> b.willAutoSync(this.holder)).orElse(false);
            if (!this.changed[i] && (!autosync || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.previous[i]))) continue;
            if (receivers == null) {
                receivers = new ArrayList<ServerPlayerEntity>(((ServerWorld)this.holder.field_70170_p).func_217490_a(serverPlayerEntity -> true));
                receivers.add((ServerPlayerEntity)this.holder);
            }
            EventHandlerEntity.syncSlot((PlayerEntity)((ServerPlayerEntity)this.holder), i, stack, receivers);
            this.changed[i] = false;
            this.previous[i] = stack.func_77946_l();
        }
    }

    public LivingEntity getHolder() {
        return this.holder;
    }
}

