/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import lazy.baubles.api.cap.BaublesCapabilities;
import lazy.baubles.api.cap.IBaublesItemHandler;
import lazy.baubles.api.render.IRenderBauble;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class BaublesRenderLayer<T extends PlayerEntity, M extends PlayerModel<T>>
extends LayerRenderer<T, M> {
    public BaublesRenderLayer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, PlayerEntity player, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        player.getCapability(BaublesCapabilities.BAUBLES).ifPresent(inv -> {
            this.dispatchRenders((IBaublesItemHandler)inv, player, IRenderBauble.RenderType.BODY, partialTicks);
            float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
            float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            GlStateManager.func_227626_N_();
            GlStateManager.func_227689_c_((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_227689_c_((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_227689_c_((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            this.dispatchRenders((IBaublesItemHandler)inv, player, IRenderBauble.RenderType.HEAD, partialTicks);
            GlStateManager.func_227627_O_();
        });
    }

    private void dispatchRenders(IBaublesItemHandler inv, PlayerEntity player, IRenderBauble.RenderType type, float partialTicks) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stack.getCapability(BaublesCapabilities.ITEM_BAUBLE).ifPresent(bauble -> {
                if (bauble instanceof IRenderBauble) {
                    GlStateManager.func_227626_N_();
                    GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ((IRenderBauble)bauble).onPlayerBaubleRender(player, type, partialTicks);
                    GlStateManager.func_227627_O_();
                }
            });
        }
    }
}

