/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.type.capability;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public interface ICurioItem {
    public static final ICurio defaultInstance = new ICurio(){};

    default public boolean hasCurioCapability(ItemStack stack) {
        return true;
    }

    default public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        defaultInstance.curioTick(identifier, index, livingEntity);
    }

    default public void curioAnimate(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        defaultInstance.curioAnimate(identifier, index, livingEntity);
    }

    default public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        this.onEquip(slotContext.getIdentifier(), slotContext.getIndex(), slotContext.getWearer(), stack);
    }

    default public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        this.onUnequip(slotContext.getIdentifier(), slotContext.getIndex(), slotContext.getWearer(), stack);
    }

    default public boolean canEquip(String identifier, LivingEntity livingEntity, ItemStack stack) {
        return defaultInstance.canEquip(identifier, livingEntity);
    }

    default public boolean canUnequip(String identifier, LivingEntity livingEntity, ItemStack stack) {
        return defaultInstance.canUnequip(identifier, livingEntity);
    }

    default public List<ITextComponent> getTagsTooltip(List<ITextComponent> tagTooltips, ItemStack stack) {
        return defaultInstance.getTagsTooltip(tagTooltips);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        return this.getAttributeModifiers(slotContext.getIdentifier(), stack);
    }

    default public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        this.playRightClickEquipSound(slotContext.getWearer(), stack);
    }

    @Nonnull
    default public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187719_p, 1.0f, 1.0f);
    }

    default public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.canRightClickEquip(stack);
    }

    default public void curioBreak(ItemStack stack, LivingEntity livingEntity) {
        defaultInstance.curioBreak(stack, livingEntity);
    }

    default public boolean canSync(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return defaultInstance.canSync(identifier, index, livingEntity);
    }

    @Nullable
    default public CompoundNBT writeSyncData(ItemStack stack) {
        return defaultInstance.writeSyncData();
    }

    default public void readSyncData(CompoundNBT compound, ItemStack stack) {
        defaultInstance.readSyncData(compound);
    }

    @Nonnull
    default public ICurio.DropRule getDropRule(LivingEntity livingEntity, ItemStack stack) {
        return defaultInstance.getDropRule(livingEntity);
    }

    default public boolean showAttributesTooltip(String identifier, ItemStack stack) {
        return defaultInstance.showAttributesTooltip(identifier);
    }

    default public int getFortuneBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
        return defaultInstance.getFortuneBonus(identifier, livingEntity, curio, index);
    }

    default public int getLootingBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
        return defaultInstance.getLootingBonus(identifier, livingEntity, curio, index);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return defaultInstance.canRender(identifier, index, livingEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        defaultInstance.render(identifier, index, matrixStack, renderTypeBuffer, light, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    @Deprecated
    default public void onEquip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        defaultInstance.onEquip(identifier, index, livingEntity);
    }

    @Deprecated
    default public void onUnequip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        defaultInstance.onUnequip(identifier, index, livingEntity);
    }

    @Deprecated
    default public void playRightClickEquipSound(LivingEntity livingEntity, ItemStack stack) {
        ICurio.SoundInfo soundInfo = this.getEquipSound(new SlotContext("", livingEntity), stack);
        livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_233580_cy_(), soundInfo.getSoundEvent(), livingEntity.func_184176_by(), soundInfo.getVolume(), soundInfo.getPitch());
    }

    @Deprecated
    default public boolean canRightClickEquip(ItemStack stack) {
        return defaultInstance.canRightClickEquip();
    }

    @Deprecated
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        return defaultInstance.getAttributeModifiers(identifier);
    }
}

