/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data;

import com.oblivioussp.spartanweaponry.api.data.BaseModels;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;

public class ModelGenerator {
    protected final ItemModelProvider itemModelProvider;

    public ModelGenerator(ItemModelProvider itemModelProviderIn) {
        this.itemModelProvider = itemModelProviderIn;
    }

    public ResourceLocation createSimpleModel(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, this.itemModelProvider.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath)).getLocation();
    }

    public ResourceLocation createSimpleModel(Item item, ResourceLocation parent) {
        String itemPath = item.getRegistryName().func_110623_a();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, parent)).texture("layer0", "item/" + itemPath)).getLocation();
    }

    public ResourceLocation createDaggerModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", BaseModels.baseDaggerThrowing)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseDagger)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("throwing"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createParryingDaggerModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation blockingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_blocking", BaseModels.baseParryingDaggerBlocking)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseParryingDagger)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(blockingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createLongswordModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseLongsword);
    }

    public ResourceLocation createKatanaModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseKatana);
    }

    public ResourceLocation createSaberModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseSaber);
    }

    public ResourceLocation createRapierModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseRapier);
    }

    public ResourceLocation createGreatswordModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseGreatsword);
    }

    public ResourceLocation createClubModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseClub);
    }

    public ResourceLocation createCestusModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseCestus);
    }

    public ResourceLocation createBattleHammerModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseBattleHammer);
    }

    public ResourceLocation createWarhammerModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseWarhammer);
    }

    public ResourceLocation createSpearModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseSpear);
    }

    public ResourceLocation createHalberdModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseHalberd);
    }

    public ResourceLocation createPikeModel(Item item) {
        return this.createSimpleModel(item, BaseModels.basePike);
    }

    public ResourceLocation createLanceModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseLance);
    }

    public ResourceLocation createLongbowModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.baseLongbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.baseLongbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.baseLongbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_2")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseLongbow)).texture("layer0", "item/" + itemPath + "_standby")).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createHeavyCrossbowModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.baseHeavyCrossbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.baseHeavyCrossbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.baseHeavyCrossbowPulling)).texture("layer0", "item/" + itemPath + "_pulling_2")).getLocation();
        ResourceLocation loaded = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_loaded", BaseModels.baseHeavyCrossbowLoaded)).texture("layer0", "item/" + itemPath + "_loaded")).getLocation();
        ResourceLocation firing = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_firing", BaseModels.baseHeavyCrossbowFiring)).texture("layer0", "item/" + itemPath + "_loaded")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseHeavyCrossbow)).texture("layer0", "item/" + itemPath + "_standby")).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("charged"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(loaded, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("charged"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(firing, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createThrowingKnifeModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", BaseModels.baseThrowingKnifeThrowing)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseThrowingKnife)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("throwing"), 1.0f).predicate(new ResourceLocation("empty"), 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("empty"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(BaseModels.baseThrowingKnifeEmpty, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createTomahawkModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", BaseModels.baseTomahawkThrowing)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseTomahawk)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("throwing"), 1.0f).predicate(new ResourceLocation("empty"), 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("empty"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(BaseModels.baseTomahawkEmpty, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createJavelinModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", BaseModels.baseJavelinThrowing)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseJavelin)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("throwing"), 1.0f).predicate(new ResourceLocation("empty"), 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("empty"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(BaseModels.baseJavelinEmpty, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createBoomerangModels(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", BaseModels.baseBoomerangThrowing)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.baseBoomerang)).texture("layer0", "item/" + itemPath)).override().predicate(new ResourceLocation("throwing"), 1.0f).predicate(new ResourceLocation("empty"), 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(new ResourceLocation("empty"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(BaseModels.baseBoomerangEmpty, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createBattleaxeModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseBattleaxe);
    }

    public ResourceLocation createFlangedMaceModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseFlangedMace);
    }

    public ResourceLocation createGlaiveModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseGlaive);
    }

    public ResourceLocation createQuarterstaffModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseQuarterstaff);
    }

    public ResourceLocation createScytheModel(Item item) {
        return this.createSimpleModel(item, BaseModels.baseScythe);
    }
}

