/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.APIConfigValues;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.MeleeCallbackWeaponTrait;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtraDamageWeaponTrait
extends MeleeCallbackWeaponTrait {
    public ExtraDamageWeaponTrait(String type, String modId, float magnitude) {
        super(type, modId, magnitude, WeaponTrait.TraitQuality.POSITIVE);
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<ITextComponent> tooltip) {
        if (APIConfigValues.damageBonusCheckArmorValue && (this.type == "extra_damage_chest" || this.type == "extra_damage_unarmoured" || this.type == "extra_damage_helmet")) {
            tooltip.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc.armor_points", "spartanweaponry", this.type), new Object[]{Float.valueOf((this.magnitude - 1.0f) * 100.0f), Float.valueOf(APIConfigValues.damageBonusMaxArmorValue)}).func_240701_a_(WeaponTrait.DESCRIPTION_COLOUR)));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type), new Object[]{Float.valueOf((this.magnitude - 1.0f) * 100.0f)}).func_240701_a_(WeaponTrait.DESCRIPTION_COLOUR)));
        }
    }

    @Override
    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        if (attacker == null || victim == null) {
            return baseDamage;
        }
        float bonusDamage = (this.getMagnitude() - 1.0f) * baseDamage;
        switch (this.type) {
            case "extra_damage_chest": {
                if (victim.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                    return !APIConfigValues.damageBonusCheckArmorValue || victim.func_233637_b_(Attributes.field_233826_i_) <= (double)APIConfigValues.damageBonusMaxArmorValue ? baseDamage + bonusDamage : baseDamage;
                }
            }
            case "extra_damage_helmet": {
                if (victim.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                    return !APIConfigValues.damageBonusCheckArmorValue || victim.func_233637_b_(Attributes.field_233826_i_) <= (double)APIConfigValues.damageBonusMaxArmorValue ? baseDamage + bonusDamage : baseDamage;
                }
            }
            case "extra_damage_unarmoured": {
                if (victim.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() && victim.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() && victim.func_184582_a(EquipmentSlotType.LEGS).func_190926_b() && victim.func_184582_a(EquipmentSlotType.FEET).func_190926_b()) {
                    return !APIConfigValues.damageBonusCheckArmorValue || victim.func_233637_b_(Attributes.field_233826_i_) <= (double)APIConfigValues.damageBonusMaxArmorValue ? baseDamage + bonusDamage : baseDamage;
                }
                return baseDamage;
            }
            case "extra_damage_riding": {
                return attacker.func_184187_bx() != null ? this.getMagnitude() * baseDamage : baseDamage;
            }
            case "extra_damage_undead": {
                return victim.func_70668_bt() == CreatureAttribute.field_223223_b_ ? this.getMagnitude() * baseDamage : baseDamage;
            }
            case "extra_damage_backstab": {
                Entity immediateEntity = source.func_76364_f();
                float yaw = source.func_76352_a() ? -immediateEntity.field_70177_z : immediateEntity.field_70177_z;
                float victimYaw = victim.field_70177_z;
                float difference = victimYaw - yaw;
                difference = this.posMod(difference + 180.0f, 360.0f) - 180.0f;
                boolean doBonusDamage = MathHelper.func_76135_e((float)difference) <= 30.0f;
                return doBonusDamage ? baseDamage + bonusDamage : baseDamage;
            }
        }
        return baseDamage;
    }

    private float posMod(float num, float den) {
        return (num % den + den) % den;
    }
}

