/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IRangedTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IThrowingTraitCallback;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WeaponTrait
implements IForgeRegistryEntry<WeaponTrait> {
    public static final TextFormatting[] DESCRIPTION_COLOUR = new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC};
    protected String type;
    protected String modId;
    protected int level;
    protected float magnitude;
    protected TraitQuality quality;
    protected ResourceLocation regName;

    public WeaponTrait(String type, String modId, int level, float magnitude, TraitQuality quality) {
        this.type = type;
        this.modId = modId;
        this.level = level;
        this.magnitude = magnitude;
        this.quality = quality;
    }

    public WeaponTrait(String type, String modId, int level, TraitQuality quality) {
        this(type, modId, level, 0.0f, quality);
    }

    public WeaponTrait(String type, String modId, float magnitude, TraitQuality quality) {
        this(type, modId, 0, magnitude, quality);
    }

    public WeaponTrait(String type, String modId, TraitQuality quality) {
        this(type, modId, 0, quality);
    }

    public String toString() {
        return String.format("WeaponTrait{Type: %s:%s - Level: %d - Magnitude: %f - Quality: %s}", this.modId, this.type, this.level, Float.valueOf(this.magnitude), this.quality.toString());
    }

    public String getType() {
        return this.type;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(float value) {
        this.magnitude = value;
    }

    public boolean isMeleeTrait() {
        return true;
    }

    public boolean isRangedTrait() {
        return false;
    }

    public boolean isThrowingTrait() {
        return false;
    }

    public IMeleeTraitCallback getMeleeCallback() {
        return null;
    }

    public IRangedTraitCallback getRangedCallback() {
        return null;
    }

    public IThrowingTraitCallback getThrowingCallback() {
        return null;
    }

    public final void addTooltip(ItemStack stack, List<ITextComponent> tooltip, boolean isShiftPressed) {
        this.addTooltipTitle(stack, tooltip);
        if (isShiftPressed && I18n.func_188566_a((String)String.format("tooltip.%s.trait.%s.desc", this.modId, this.type))) {
            this.addTooltipDescription(stack, tooltip);
        }
    }

    protected void addTooltipTitle(ItemStack stack, List<ITextComponent> tooltip) {
        if (this.level == 0) {
            tooltip.add((ITextComponent)new StringTextComponent("- ").func_240699_a_(this.quality.getFormatting()).func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s", this.modId, this.type))));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("- ").func_240699_a_(this.quality.getFormatting()).func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s", this.modId, this.type)).func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + Integer.toString(this.level)))));
        }
    }

    protected void addTooltipDescription(ItemStack stack, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc", this.modId, this.type)).func_240701_a_(DESCRIPTION_COLOUR)));
    }

    public WeaponTrait setRegistryName(ResourceLocation name) {
        this.regName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.regName;
    }

    public Class<WeaponTrait> getRegistryType() {
        return WeaponTrait.class;
    }

    public static enum TraitQuality {
        POSITIVE(TextFormatting.GREEN),
        NEUTRAL(TextFormatting.YELLOW),
        NEGATIVE(TextFormatting.RED);

        private TextFormatting formatting;

        private TraitQuality(TextFormatting formatting) {
            this.formatting = formatting;
        }

        public TextFormatting getFormatting() {
            return this.formatting;
        }
    }
}

