/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client;

import com.oblivioussp.spartanweaponry.block.ExtendedSkullBlock;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverArrowScreen;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverBoltScreen;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ArrowBaseRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.BoltRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.BoomerangRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.EndermanHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.HeadwearHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.IllagerHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.JavelinRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.PiglinHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.SimpleArrowRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ThrowingWeaponRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.TomahawkRenderFactory;
import com.oblivioussp.spartanweaponry.client.renderer.entity.WitchHeadModel;
import com.oblivioussp.spartanweaponry.entity.projectile.DynamiteEntity;
import com.oblivioussp.spartanweaponry.init.ModContainers;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModTileEntities;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.LongbowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    public static void registerItemRenders() {
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowWood);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowIron);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowDiamond);
        ClientHelper.registerTippedProjectile(ModItems.tippedBolt);
        ClientHelper.registerTippedProjectile(ModItems.tippedBoltDiamond);
    }

    public static void registerBlockablePropertyOverrides(SwordBaseItem parryingDagger) {
        ItemModelsProperties.func_239418_a_((Item)parryingDagger, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    public static void registerHeavyCrossbowPropertyOverrides(HeavyCrossbowItem crossbow) {
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("pull"), (stack, world, living) -> {
            if (living != null) {
                return crossbow.isLoaded(stack) ? 0.0f : (float)crossbow.getLoadingTicks(stack, living) / (float)crossbow.getFullLoadTicks(stack);
            }
            return 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("charged"), (stack, world, living) -> crossbow.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public static void registerLongbowPropertyOverrides(LongbowItem longbow) {
        ItemModelsProperties.func_239418_a_((Item)longbow, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)longbow, (ResourceLocation)new ResourceLocation("pull"), (stack, world, shooter) -> shooter != null && shooter.func_184607_cu() == stack ? longbow.getNockProgress(stack, shooter) : 0.0f);
    }

    public static void registerThrowingWeaponPropertyOverrides(Item throwingWeapon) {
        ItemModelsProperties.func_239418_a_((Item)throwingWeapon, (ResourceLocation)new ResourceLocation("throwing"), (stack, world, living) -> {
            if (living == null || !stack.func_77969_a(living.func_184607_cu())) {
                return 0.0f;
            }
            return living.func_184605_cv() > 0 ? 1.0f : 0.0f;
        });
        if (throwingWeapon instanceof ThrowingWeaponItem) {
            ItemModelsProperties.func_239418_a_((Item)throwingWeapon, (ResourceLocation)new ResourceLocation("empty"), (stack, world, living) -> stack.func_196082_o().func_74762_e("AmmoUsed") == ((ThrowingWeaponItem)throwingWeapon).getMaxAmmo(stack) ? 1.0f : 0.0f);
        }
    }

    public static void registerQuiverPropertyOverrides(QuiverBaseItem quiver) {
        ItemModelsProperties.func_239418_a_((Item)quiver, (ResourceLocation)new ResourceLocation("arrow"), (stack, world, living) -> quiver.getAmmoCount(stack));
    }

    public static void registerTippedProjectile(Item arrow) {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, idx) -> idx == 1 ? PotionUtils.func_190932_c((ItemStack)stack) : 0xFFFFFF, new IItemProvider[]{arrow});
    }

    public static void registerExtendedSkullRenders() {
        GenericHeadModel genericHeadModel = new GenericHeadModel(0, 0, 64, 32);
        EndermanHeadModel endermanHeadModel = new EndermanHeadModel();
        GenericHeadModel spiderHeadModel = new GenericHeadModel(32, 4, 64, 32);
        PiglinHeadModel piglinModel = new PiglinHeadModel();
        GenericHeadModel huskHeadModel = new GenericHeadModel(0, 0, 64, 64);
        HeadwearHeadModel headwearHeadModel = new HeadwearHeadModel();
        IllagerHeadModel illagerHeadModel = new IllagerHeadModel();
        WitchHeadModel witchHeadModel = new WitchHeadModel();
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.BLAZE, genericHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.ENDERMAN, endermanHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.SPIDER, spiderHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.CAVE_SPIDER, spiderHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.PIGLIN, piglinModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.ZOMBIE_PIGLIN, piglinModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.HUSK, huskHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.STRAY, headwearHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.DROWNED, headwearHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.ILLAGER, illagerHeadModel);
        SkullTileEntityRenderer.field_199358_e.put(ExtendedSkullBlock.Types.WITCH, witchHeadModel);
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.BLAZE, new ResourceLocation("minecraft", "textures/entity/blaze.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.ENDERMAN, new ResourceLocation("spartanweaponry", "textures/entity/skull/enderman_head.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.SPIDER, new ResourceLocation("minecraft", "textures/entity/spider/spider.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.CAVE_SPIDER, new ResourceLocation("minecraft", "textures/entity/spider/cave_spider.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.PIGLIN, new ResourceLocation("minecraft", "textures/entity/piglin/piglin.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.ZOMBIE_PIGLIN, new ResourceLocation("minecraft", "textures/entity/piglin/zombified_piglin.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.HUSK, new ResourceLocation("minecraft", "textures/entity/zombie/husk.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.STRAY, new ResourceLocation("spartanweaponry", "textures/entity/skull/stray_skull.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.DROWNED, new ResourceLocation("spartanweaponry", "textures/entity/skull/drowned_head.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.ILLAGER, new ResourceLocation("minecraft", "textures/entity/illager/pillager.png"));
        SkullTileEntityRenderer.field_199357_d.put(ExtendedSkullBlock.Types.WITCH, new ResourceLocation("minecraft", "textures/entity/witch.png"));
        Log.info("Successfully added extended Skull renders!");
    }

    public static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_SW, new ArrowBaseRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_EXPLOSIVE, new SimpleArrowRenderFactory("textures/entity/projectiles/arrow_explosive.png"));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT_SPECTRAL, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWING_WEAPON, new ThrowingWeaponRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TOMAHAWK, new TomahawkRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.JAVELIN, new JavelinRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOOMERANG, (IRenderFactory)new BoomerangRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.DYNAMITE, (IRenderFactory)new IRenderFactory<DynamiteEntity>(){

            public EntityRenderer<? super DynamiteEntity> createRenderFor(EntityRendererManager manager) {
                return new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af());
            }
        });
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.EXTENDED_SKULL_TYPE, dispatcher -> new SkullTileEntityRenderer(dispatcher));
    }

    public static void registerScreens() {
        ScreenManager.func_216911_a(ModContainers.QUIVER_ARROW, QuiverArrowScreen::new);
        ScreenManager.func_216911_a(ModContainers.QUIVER_BOLT, QuiverBoltScreen::new);
    }
}

