/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.oblivioussp.spartanweaponry.client.model.QuiverModelBase;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class QuiverCurioRenderer
implements ICurio {
    protected final ItemStack quiverStack;
    protected final QuiverBaseItem quiverItem;
    protected final QuiverModelBase model;
    protected final ResourceLocation texture;

    public QuiverCurioRenderer(QuiverBaseItem item, ItemStack stack) {
        this.quiverItem = item;
        this.quiverStack = stack;
        if (FMLEnvironment.dist.isClient()) {
            this.model = item.getModel();
            this.texture = item.getModelTexture();
        } else {
            this.model = null;
            this.texture = null;
        }
    }

    public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
        IItemHandlerModifiable curiosHandler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(livingEntity).orElse(null);
        if (curiosHandler == null) {
            return false;
        }
        ItemStack curioInSlot = curiosHandler.getStackInSlot(index);
        return this.quiverStack.func_77973_b() == curioInSlot.func_77973_b() && !this.quiverStack.areShareTagsEqual(curioInSlot);
    }

    public void readSyncData(CompoundNBT compound) {
        this.quiverItem.readShareTag(this.quiverStack, compound);
    }

    public CompoundNBT writeSyncData() {
        return this.quiverItem.getShareTag(this.quiverStack);
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int ammoFilled = this.quiverItem.getAmmoCount(this.quiverStack);
        if (this.model != null) {
            this.model.setArrowsToRender(ammoFilled);
            ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            this.model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(this.model.func_228282_a_(this.texture)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

