/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.collect.Lists;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.util.ArmorPiercingIndirectEntityDamageSource;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BoltEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    protected final String NBT_BOLT = "Bolt";
    protected final String NBT_POTION = "Potion";
    protected final String NBT_POTION_COLOUR = "PotionColour";
    protected static final DataParameter<Integer> DATA_COLOUR = EntityDataManager.func_187226_a(BoltEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<ItemStack> DATA_BOLT = EntityDataManager.func_187226_a(BoltEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected Potion potion = Potions.field_185229_a;
    protected float baseDamage = 1.0f;
    protected float rangeMultiplier = 1.0f;
    protected float armorPiercingFactor = 0.0f;

    public BoltEntity(EntityType<? extends BoltEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public BoltEntity(EntityType<? extends BoltEntity> type, double x, double y, double z, World worldIn) {
        super(type, x, y, z, worldIn);
    }

    public BoltEntity(EntityType<? extends BoltEntity> type, LivingEntity shooter, World world) {
        super(type, shooter, world);
    }

    public BoltEntity(LivingEntity shooter, World world) {
        this(ModEntities.BOLT, shooter, world);
    }

    public BoltEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.BOLT, world);
    }

    public void initEntity(float baseDamage, float rangeMultiplier, float armorPiercingFactor, ItemStack boltStack) {
        this.baseDamage = baseDamage;
        this.rangeMultiplier = rangeMultiplier;
        this.armorPiercingFactor = armorPiercingFactor;
        this.func_70239_b(baseDamage);
        this.func_184212_Q().func_187227_b(DATA_BOLT, (Object)boltStack);
    }

    public void func_234612_a_(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        super.func_234612_a_(shooter, pitch, yaw, p_184547_4_, velocity * this.rangeMultiplier, inaccuracy);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLOUR, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_BOLT, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = Potions.field_185229_a;
            this.field_70180_af.func_187227_b(DATA_COLOUR, (Object)-1);
        }
    }

    protected DamageSource causeArmorPiercingDamage(Entity sourceEntity, Entity indirectEntity) {
        return new ArmorPiercingIndirectEntityDamageSource("arrow", sourceEntity, indirectEntity, this.armorPiercingFactor).func_76349_b();
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        DamageSource source;
        Entity shooter;
        Entity entity = result.func_216348_a();
        float velocity = (float)this.func_213322_ci().func_72433_c();
        int damage = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)velocity * this.func_70242_d()), (double)0.0, (double)2.147483647E9));
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(entity.func_145782_y());
        }
        if (this.func_70241_g()) {
            long critDamageBonus = this.field_70146_Z.nextInt(damage / 2 + 2);
            damage = (int)Math.min(critDamageBonus + (long)damage, Integer.MAX_VALUE);
        }
        if ((shooter = this.func_234616_v_()) == null) {
            source = this.causeArmorPiercingDamage((Entity)this, (Entity)this);
        } else {
            source = this.causeArmorPiercingDamage((Entity)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).func_130011_c(entity);
            }
        }
        boolean isEnderman = entity.func_200600_R() == EntityType.field_200803_q;
        int fireTimer = entity.func_223314_ad();
        if (this.func_70027_ad() && !isEnderman) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(source, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)shooter);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)livingentity);
                }
                this.func_184548_a(livingentity);
                if (shooter != null && livingentity != shooter && livingentity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!entity.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingentity);
                }
                if (!this.field_70170_p.field_72995_K && shooter instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, (Collection)this.field_213875_aA);
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(fireTimer);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        for (EffectInstance effect : this.potion.func_185170_a()) {
            living.func_195064_c(new EffectInstance(effect.func_188419_a(), Math.max(effect.func_76459_b() / 8, 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
    }

    protected ItemStack func_184550_j() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_BOLT);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.func_213293_j(x, y, z);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        this.field_70180_af.func_187227_b(DATA_COLOUR, (Object)(compound.func_74764_b("PotionColour") ? compound.func_74762_e("PotionColour") : -1));
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.func_213322_ci().func_82615_a());
        buffer.writeDouble(this.func_213322_ci().func_82617_b());
        buffer.writeDouble(this.func_213322_ci().func_82616_c());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.potion != null && this.potion != Potions.field_185229_a) {
            compound.func_74778_a("Potion", ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)this.potion).toString());
        }
        compound.func_74768_a("PotionColour", ((Integer)this.field_70180_af.func_187225_a(DATA_COLOUR)).intValue());
    }

    public void setPotionEffect(ItemStack stack) {
        this.potion = PotionUtils.func_185191_c((ItemStack)stack);
        this.field_70180_af.func_187227_b(DATA_COLOUR, (Object)PotionUtils.func_190932_c((ItemStack)stack));
    }

    private void spawnPotionParticles(int particleCount) {
        int colour = (Integer)this.field_70180_af.func_187225_a(DATA_COLOUR);
        if (colour != -1 && particleCount > 0) {
            double cR = (double)(colour >> 16 & 0xFF) / 255.0;
            double cG = (double)(colour >> 8 & 0xFF) / 255.0;
            double cB = (double)(colour >> 0 & 0xFF) / 255.0;
            for (int i = 0; i < particleCount; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), cR, cG, cB);
            }
        }
    }

    public boolean isValid() {
        return !this.func_184550_j().func_190926_b();
    }

    public ResourceLocation getTexture() {
        int idx;
        ItemStack boltStack = this.func_184550_j();
        if (boltStack.func_190926_b()) {
            return new ResourceLocation("spartanweaponry", "missing_stack");
        }
        String boltRegName = boltStack.func_77973_b().getRegistryName().func_110623_a();
        if (this.potion.getRegistryName().func_110623_a() != "empty" && (idx = boltRegName.indexOf("_tipped")) != -1) {
            boltRegName = boltRegName.substring(0, idx);
        }
        return new ResourceLocation("spartanweaponry", "textures/entity/projectiles/" + boltRegName + ".png");
    }
}

